#ifndef __HTTPSD_FIREMAN_CLIENT_H__
#define __HTTPSD_FIREMAN_CLIENT_H__

#include <stdsoap2.h>
#include <string>
#include <list>

#include "../client/client.h"

#include "../../datamove/datapoint.h"

#include "object_access_fireman.h"

/// Minimal set of operations on Fireman database. Mostly needed to
/// implement corresponding DataPoint class.
class FiremanClient {
/*
 public:
  class Permission {
   friend class FiremanClient;
   private:
    std::string name;
    bool read_;
    bool write_;
    bool list_;
    bool admin_;
   public:
    Permission(const char* id);
    void read(bool);
    void write(bool);
    void list(bool);
    void admin(bool);
  };
*/
 private:
  struct soap soap;
  HTTP_ClientSOAP* c;
  int timeout;
  ObjectAccessFireman* acl;
 public:
  FiremanClient(const char* base_url);
  ~FiremanClient(void);
  bool connect(void);
  bool disconnect(void);
  /// Create file
  bool add(const char* name,
       unsigned long long int size,const std::string& checksum,time_t time);
  /// Create file with associated replicas
  bool add(const char* name,
       unsigned long long int size,const std::string& checksum,time_t time,
       const std::list<std::string>& urls);
  /// Add replicas to file
  bool add(const char* name,
       const std::list<std::string>& urls);
  /// Get minimal associated metadata
  bool info(const char* name,
       unsigned long long int& size,std::string& checksum,time_t& time,
       DataPoint::FileInfo::Type& type);
  /// Get list of file replicas and minimal associated metadata
  bool info(const char* name,
       unsigned long long int& size,std::string& checksum,time_t& time,
       DataPoint::FileInfo::Type& type,
       std::list<std::string>& urls);
  /// Get list of file replicas
  bool info(const char* name,
       std::list<std::string>& urls);
  /// Remove file and all associated info (attributes, replicas)
  bool remove(const char* name);
  /// Remove associated replicas
  bool remove(const char* name,const std::list<std::string>& urls);
  bool list(const char* path,std::list<std::string>& names);
  bool acl_set(const ObjectAccess& o);
  operator bool(void) { return c; };
  bool operator!(void) { return !c; };
};

class DataPointFireman: public DataPointMeta {
 private:
  FiremanClient* c;
 protected:
  virtual bool process_meta_url(void);
 public:
  DataPointFireman(const char* url);
  virtual ~DataPointFireman(void);
  static DataPoint* CreateInstance(const char* url);
  virtual bool meta_resolve(bool source);
  virtual bool meta_preregister(bool replication,bool force = false);
  virtual bool meta_postregister(bool replication,bool failure);
  virtual bool meta_preunregister(bool replication);
  virtual bool meta_unregister(bool all);
  virtual bool list_files(std::list<DataPoint::FileInfo> &files,bool resolve = true);};


#endif // __HTTPSD_FIREMAN_CLIENT_H__
