#ifndef __ARC_SRM_FILE_H__
#define __ARC_SRM_FILE_H__

#include <string>

class SRMRequests;
class SRMLocalRequest;
class SRMRemoteRequest;
class SRMFileMetaData;
class SRMFileStatus;

class SRMFile {
 friend class SRMRequests;
 friend class SRMRequest;
 friend class SRMLocalRequest;
 friend class SRMRemoteRequest;
 private:
  std::string name; // File's name with SRM part stripped or TURL
  bool is_turl; // SRMv1 identifies files by TURL in pin/unpin
  // std::string local_id;   // File's id in pending request
  std::string remote_id;  // File's id on remote server
  SRMRemoteRequest* request;
  SRMFileMetaData* metadata;
  SRMFileStatus* status;
 public:
  SRMFile(void);
  ~SRMFile(void);
  void MetaData(SRMFileMetaData* metadata);
  const SRMFileMetaData* MetaData(void) const { return metadata; };
  void Status(SRMFileStatus* status);
  const SRMFileStatus* Status(void) const { return status; };
};

#endif
