#include "../../std.h"

#include "../../misc/inttostring.h"
#include "../../misc/url_options.h"

#include "srm_url.h"

std::string SRM_URL::empty("");

std::string SRM_URL::ContactURL(void) const {
  if(!valid) return empty;
  return ("httpg://"+host+":"+inttostring(port)+path);
}

std::string SRM_URL::BaseURL(void) const {
  if(!valid) return empty;
  return (protocol+"://"+host+":"+inttostring(port)+path+"?SFN=");
}

std::string SRM_URL::FullURL(void) const {
  if(!valid) return empty;
  return (protocol+"://"+host+":"+inttostring(port)+path+"?SFN="+filename);
}

std::string SRM_URL::ShortURL(void) const {
  return (protocol+"://"+host+":"+inttostring(port)+"/"+filename);
}

SRM_URL::SRM_URL(const char* url) try: URL(url) {
  if(protocol != "srm") { valid=false; return; };
  valid=true;
  if(port <= 0) port=8443;
  std::string::size_type p = path.find("?SFN=");
  if(p != std::string::npos) {
    filename=path.c_str()+p+5;
    path.resize(p);
    isshort=false;
    for(;path.size() > 1;) {
      if(path[1] != '/') break;
      path.erase(0,1);
    };
    return;
  };
  // Only supported version from client's side is 1.1
  if(path.length() > 0) filename=path.c_str()+1; // Skip leading '/'
  //path="srm/srm.1.1.endpoint";
  path="/srm/managerv1";
  isshort=true;
} catch (std::exception e) {
  valid=false;
}

bool SRM_URL::GSSAPI(void) const {
  try {
    const std::string proto_val =
          ((std::map<std::string,std::string>&)(Options()))["protocol"];
    if(proto_val == "gssapi") return true;
  } catch (std::exception e) { };
  return false;
}

