#ifndef __ARC_SRM_REQUEST_H__
#define __ARC_SRM_REQUEST_H__

#include <string>
#include <list>

#include "../se/files.h"
#include "srm1_soapH.h"
#include "../../misc/thread.h"

class SRMRequests;
class SRMRequest;

class SRMRequestFile {
 friend class SRMRequest;
 private:
  SEFiles::iterator f_;
  bool running_;
  bool shorturl_;
  SRMRequestFile(SEFiles::iterator& f):f_(f),running_(false),shorturl_(false) { };
 public:
  bool running(void) { return running_; };
  void running(bool r) { running_=r; };
  bool shorturl(void) { return shorturl_; };
  void shorturl(bool r) { shorturl_=r; };
  SEFile& file(void) { return *f_; };
};

class SRMRequest {
 friend class SRMRequests;
 protected:
  std::list<SRMRequestFile> files_;
  std::string state_;
  int id_;
  std::string userid_;
  std::string type_;
  time_t created_;
  LockSimple lock_;
 public:
  SRMRequest(int id,const char* userid,const char* type);
  virtual ~SRMRequest(void);
  virtual SRMRequestFile* add(SEFiles::iterator& file);
  virtual bool active(void);
  virtual const char* type(void);
  virtual SRMv1Type__RequestStatus* get(struct soap* sp,const char* service_url);
  void acquire(void) { lock_.block(); };
  void release(void) { lock_.unblock(); };
  int id(void) { return id_; };
  SRMRequestFile* file(int fileid);
};

class SRMRequests {
 private:
  std::list<SRMRequest*> reqs_;
  LockSimple lock_;
 public:
  SRMRequests(void);
  ~SRMRequests(void);
  void add(SRMRequest* req);
  SRMRequest* acquire(int id,const char* userid);
  //bool release(int id);
  bool remove(int id);
  bool maintain(int id);
  bool maintain(void);
};

class SRMRequests_Thread: public Thread {
 private:
  SRMRequests& reqs_;
  virtual void func(void);
 public:
  SRMRequests_Thread(SRMRequests& r):reqs_(r) { attention(); };
  ~SRMRequests_Thread(void) { };
};

#endif // __ARC_SRM_REQUEST_H__
