#ifndef __HTTPSD_SRM_CLIENT_H__
#define __HTTPSD_SRM_CLIENT_H__

#include <string>
#include <list>

#include "srm_url.h"

#include "../client/client.h"

class SRMClient;

class SRMClientRequest {
 friend class SRMClient;
 private:
  int request_id;
  std::list<int> file_ids;
 public:
  SRMClientRequest(void):request_id(-1) { };
  ~SRMClientRequest(void) { };
};

class SRMClient {
 private:
  bool valid;
  struct soap soap;
  HTTP_ClientSOAP* c;
  int timeout;
  bool acquire(SRMClientRequest& req,std::list<std::string>& urls);
 public:
  SRMClient(const char* base_url,bool gssapi_server = false);
  SRMClient(const SRM_URL& base_url);
  ~SRMClient(void);
  bool connect(void);
  bool disconnect(void);
  void Timeout(int t) { timeout=t; };
  bool getTURLs(SRMClientRequest& r,const char* name,const SRM_URL& srm_url,
                     std::list<std::string>& urls);
  bool putTURLs(SRMClientRequest& r,const char* name,const SRM_URL& srm_url,
                     std::list<std::string>& urls,unsigned long long size = 0);
  bool release(SRMClientRequest& r,const char* name,const SRM_URL& srm_url);
  bool info(const char* name,const SRM_URL& srm_url,
                     unsigned long long int& size,std::string& checksum);
  bool remove(const char* name,const SRM_URL& srm_url);
  bool copy(SRMClientRequest& req,const char* name,const SRM_URL& srm_url,
                     const std::string& source);
  operator bool(void) { return c; };
  bool operator!(void) { return !c; };
};

#endif // __HTTPSD_SRM_CLIENT_H__
