#include "../../std.h"

#include <string>

#include "../se.h"
#include "../se/files.h"
#include "../../datamove/datapoint.h"
#include "../../auth/object_access_gacl.h"
#include "../../misc/log_time.h"
#include "../../misc/escaped.h"
#include "../../misc/time_utils.h"

// one more hack
#undef SOAP_FMAC3
#define WITH_NOGLOBAL
#define SOAP_FMAC3 static
// For namespaces table
#include "srm2_soap.nsmap"
#include "srm2_soapC.cpp"
#include "srm2_soapClient.cpp"
#include "srm2_soapServer.cpp"

#include "srm_url.h"
#include "srm_utils.h"
#include "srm_request.h"
#include "permission_srm.h"
#include "object_access_srm.h"

#include "srm.h"


// --------------------------------------------------------------
// Utilities 

static SRMv2__TMetaDataPathDetail* fill_file(struct soap *sp,SEFile* f,const std::string& service_url) {
  SRMv2__TMetaDataPathDetail* rec = soap_new_SRMv2__TMetaDataPathDetail(sp,-1);
  if(rec == NULL) return NULL;
  rec->soap_default(sp);
  // Fill record
  rec->path=soap_strdup(sp,f->id());
  rec->status=soap_new_SRMv2__TReturnStatus(sp,-1);
  if(rec->status) {
    rec->status->soap_default(sp);
    rec->status->statusCode=SRMv2__TStatusCode__SRM_USCORESUCCESS;
  };
  if(f->size_available()) {
    rec->size=soap_new_SRMv2__TSizeInBytes(sp,-1);
    if(rec->size) {
      rec->size->soap_default(sp);
      rec->size->value=f->size();
    };
  };
  rec->fileStorageType=(SRMv2__TFileStorageType*)soap_malloc(sp,sizeof(SRMv2__TFileStorageType));
  if(rec->fileStorageType)
    *(rec->fileStorageType)=SRMv2__TFileStorageType__Permanent;
  rec->type=(SRMv2__TFileType*)soap_malloc(sp,sizeof(SRMv2__TFileType));
  if(rec->type) *(rec->type)=SRMv2__TFileType__File;
  if(f->checksum_available()) {
    char* checksumType;
    char* checksumValue;
    convert_checksum(sp,f->checksum(),&checksumType,&checksumValue);
    rec->checkSumType=soap_new_SRMv2__TCheckSumType(sp,-1);
    if(rec->checkSumType) {
      rec->checkSumType->soap_default(sp);
      rec->checkSumType->value=checksumType;
    };
    rec->checkSumValue=soap_new_SRMv2__TCheckSumValue(sp,-1);
    if(rec->checkSumValue) {
      rec->checkSumValue->soap_default(sp);
      rec->checkSumValue->value=checksumValue;
    };
  };
  rec->status=soap_new_SRMv2__TReturnStatus(sp,-1);
  if(rec->status) {
    rec->status->soap_default(sp);
    rec->status->statusCode=SRMv2__TStatusCode__SRM_USCORESUCCESS;
  };
  rec->owner=soap_new_SRMv2__TUserID(sp,-1);
  if(rec->owner) {
    rec->owner->soap_default(sp);
    rec->owner->value=soap_strdup(sp,f->creator().c_str());
  };
  rec->originalSURL=soap_new_SRMv2__TSURL(sp,-1);
  if(rec->originalSURL) {
    rec->originalSURL->soap_default(sp);
    rec->originalSURL->value=soap_strdup(sp,
                   make_SURL(service_url,f->id()).c_str());
  };
  rec->subPaths=NULL;
  if(f->created_available()) {
    rec->createdAtTime=soap_new_SRMv2__TGMTTime(sp,-1);
    if(rec->createdAtTime) {
      rec->createdAtTime->soap_default(sp);
      rec->createdAtTime->value=timegm((struct tm *)f->created());
    };
    rec->lastModificationTime=rec->createdAtTime;
  };
  rec->lifetimeAssigned=NULL;
  rec->lifetimeLeft==NULL;
  std::string acl;
  if(f->read_acl(AuthUser(),acl) == 0) {
    ObjectAccessGACL o_g(acl.c_str());
    ObjectAccessSRMv2 o_s(o_g);
    SRMv2__TUserID uid; uid.soap_default(sp); uid.value=rec->owner->value;
    rec->ownerPermission=soap_new_SRMv2__TOwnerPermission(sp,-1);
    if(rec->ownerPermission) rec->ownerPermission->mode=o_s.get(sp,&uid);
    rec->userPermissions=o_s.get(sp);
    rec->groupPermissions=NULL; // What is a difference between user and group
    rec->otherPermission=NULL; // So far
  };
  return rec;
}

// --------------------------------------------------------------
// Supported methods

int SRMv2__srmLs(struct soap* sp, SRMv2__srmLsRequest *req, struct SRMv2__srmLsResponse_ &resp) {
  HTTP_SRM* it = (HTTP_SRM*)(sp->user);
  // Initialize default error response
  resp.srmLsResponse=soap_new_SRMv2__srmLsResponse(sp,-1);
  if(!resp.srmLsResponse) return SOAP_OK;
  resp.srmLsResponse->returnStatus=soap_new_SRMv2__TReturnStatus(sp,-1);
  if(!resp.srmLsResponse->returnStatus) return SOAP_OK;
  resp.srmLsResponse->returnStatus->statusCode=
                         SRMv2__TStatusCode__SRM_USCOREFAILURE;
  if((it == NULL) || (it->se == NULL)) {
    return SOAP_OK;
  };
  // Find names of requested objects
  if((req == NULL) || (req->paths == NULL) || 
     (req->paths->surlInfoArray == NULL) || (req->paths->__sizesurlInfoArray == 0)) {
    // Nothing requested
    resp.srmLsResponse->returnStatus->statusCode=
                         SRMv2__TStatusCode__SRM_USCOREINVALID_USCOREREQUEST;
    return SOAP_OK;
  };
  if((req->fileStorageType) && 
     (*(req->fileStorageType) != SRMv2__TFileStorageType__Permanent)) {
    // Only permanent files are stored in SSE
    resp.srmLsResponse->returnStatus->statusCode=
                         SRMv2__TStatusCode__SRM_USCORESUCCESS;
    return SOAP_OK;
  };
  resp.srmLsResponse->details=soap_new_SRMv2__ArrayOfTMetaDataPathDetail(sp,-1);
  if(resp.srmLsResponse->details == NULL) return SOAP_OK;
  resp.srmLsResponse->details->__sizepathDetailArray=0;
  resp.srmLsResponse->details->pathDetailArray=NULL;
  int n_out = 0;
  int n_alloc = 0;
  int n_info = 0;
  int offset = 0; if(req->offset) offset=*(req->offset);
  int count = -1; if(req->count) count=*(req->count);
  for(int n=0;n<req->paths->__sizesurlInfoArray;n++) {
    if(req->paths->surlInfoArray[n] == NULL) continue;
    if(req->paths->surlInfoArray[n]->SURLOrStFN == NULL) continue;
    if(req->paths->surlInfoArray[n]->SURLOrStFN->value == NULL) continue;
    // It is completely unclear what to do with req->authorizationID
    int subdirs = 0;
    if(req->numOfLevels) subdirs=*(req->numOfLevels);
    if(req->allLevelRecursive && (*(req->allLevelRecursive) == true))
                                                              subdirs=-1;
    std::string name = req->paths->surlInfoArray[n]->SURLOrStFN->value;
    while(name.length()) {
      if(name[name.length()-1] == '/') {
        name.resize(name.length()-1);
      } else {
        break;
      };
    };
    SEFiles* files = it->se->files();
    // Top level access
    int acl_top_flags = (files->check_acl(it->c->identity()) | 
                         it->se->check_acl()) & FILE_ACC_LIST;
    SEFiles::iterator f;
    files->acquire();
    f=files->begin();
    // TODO: req->fullDetailedList
    for(;f!=files->end();++f) {
      if((count >= 0) && (n_out >= count)) break;
      odlog(VERBOSE)<<"srmLs: file: "<<f->id()<<std::endl;
      if((f->state_file()==FILE_STATE_COMPLETE) ||
         (f->state_file()==FILE_STATE_VALID)) {
        if((name == f->id()) || (
           ((strncmp(name.c_str(),f->id(),name.length()) == 0) &&
            (f->id()[name.length()] == '/'))
           )) {
          odlog(DEBUG)<<"srmLs: matched"<<std::endl;
          if(acl_top_flags || 
             (f->check_acl(it->c->identity()) & FILE_ACC_LIST)) {
            odlog(VERBOSE)<<"srmLs: allowed"<<std::endl;
            if(n_info < offset) { n_info++; continue; }; 
            // new record
            SRMv2__TMetaDataPathDetail* rec =
                              fill_file(sp,&(*f),it->service_url);
            if(rec == NULL) {
              files->release();
              return SOAP_OK;
            };
            // manage array's size
            if(n_alloc<=n_out) {
              n_alloc+=100;
              SRMv2__TMetaDataPathDetail** f_tmp = 
                            resp.srmLsResponse->details->pathDetailArray;
              resp.srmLsResponse->details->pathDetailArray=
                          (SRMv2__TMetaDataPathDetail**)soap_malloc(sp,
                          sizeof(SRMv2__TMetaDataPathDetail*)*n_alloc);
              if(resp.srmLsResponse->details->pathDetailArray == NULL) {
                if(f_tmp != NULL) soap_dealloc(sp,f_tmp);
                files->release();
                return SOAP_OK;
              };
              if(f_tmp != NULL) {
                memcpy(resp.srmLsResponse->details->pathDetailArray,f_tmp,
                          sizeof(SRMv2__TMetaDataPathDetail*)*(n_alloc-100));
                soap_dealloc(sp,f_tmp);
              };
            };
            resp.srmLsResponse->details->pathDetailArray[n_out]=rec;
            n_out++; n_info++;
          };
        };
      };
    };
    files->release();
  };
  resp.srmLsResponse->returnStatus->statusCode=
                         SRMv2__TStatusCode__SRM_USCORESUCCESS;
  resp.srmLsResponse->details->__sizepathDetailArray=n_out;
  return SOAP_OK;
}


int SRMv2__srmRm(struct soap* sp, SRMv2__srmRmRequest *req, struct SRMv2__srmRmResponse_ &resp) {
  HTTP_SRM* it = (HTTP_SRM*)(sp->user);
  // Initialize default error response
  resp.srmRmResponse = soap_new_SRMv2__srmRmResponse(sp,-1);
  if(resp.srmRmResponse == NULL) return SOAP_OK;
  resp.srmRmResponse->soap_default(sp);
  resp.srmRmResponse->returnStatus=soap_new_SRMv2__TReturnStatus(sp,-1);
  if(resp.srmRmResponse->returnStatus == NULL) return SOAP_OK;
  resp.srmRmResponse->returnStatus->soap_default(sp);
  resp.srmRmResponse->returnStatus->statusCode=SRMv2__TStatusCode__SRM_USCOREFAILURE;
  if(req == NULL) return SOAP_OK;
  if(req->arrayOfFilePaths == NULL) return SOAP_OK; 
  if((req->arrayOfFilePaths->surlInfoArray  == NULL) || 
     (req->arrayOfFilePaths->__sizesurlInfoArray == 0)) {
    resp.srmRmResponse->returnStatus->statusCode=
                         SRMv2__TStatusCode__SRM_USCORESUCCESS;
    return SOAP_OK; 
  };
  resp.srmRmResponse->arrayOfFileStatuses=soap_new_SRMv2__ArrayOfTSURLReturnStatus(sp,-1);
  if(resp.srmRmResponse->arrayOfFileStatuses == NULL) return SOAP_OK;
  resp.srmRmResponse->arrayOfFileStatuses->soap_default(sp);
  resp.srmRmResponse->arrayOfFileStatuses->surlReturnStatusArray=(SRMv2__TSURLReturnStatus**)soap_malloc(sp,sizeof(SRMv2__TSURLReturnStatus*)*(req->arrayOfFilePaths->__sizesurlInfoArray));
  if(resp.srmRmResponse->arrayOfFileStatuses->surlReturnStatusArray == NULL) return SOAP_OK;
  SEFiles* files = it->se->files();
  // Top level access
  int acl_top_flags =
               (files->check_acl(it->c->identity()) | it->se->check_acl()) &
               FILE_ACC_DELETE;
  SRMv2__TSURLReturnStatus** statuses = 
                  resp.srmRmResponse->arrayOfFileStatuses->surlReturnStatusArray;
  int n = 0;
  for(;n<req->arrayOfFilePaths->__sizesurlInfoArray;n++) {
    SRMv2__TSURLInfo* url_inf = req->arrayOfFilePaths->surlInfoArray[n];
    if(url_inf == NULL) continue;
    if(url_inf->SURLOrStFN == NULL) continue;
    if(url_inf->SURLOrStFN->value == NULL) continue;
    const char* id = url_inf->SURLOrStFN->value;
    statuses[n]=soap_new_SRMv2__TSURLReturnStatus(sp,-1);
    if(statuses[n] == NULL) return SOAP_OK;
    statuses[n]->soap_default(sp);
    statuses[n]->status=soap_new_SRMv2__TReturnStatus(sp,-1);
    if(statuses[n]->status == NULL) return SOAP_OK;
    statuses[n]->status->statusCode=SRMv2__TStatusCode__SRM_USCOREFAILURE;
    statuses[n]->surl=soap_new_SRMv2__TSURL(sp,-1);
    if(statuses[n]->surl == NULL) return SOAP_OK;
    statuses[n]->surl->soap_default(sp);
    statuses[n]->surl->value=soap_strdup(sp,
                         make_SURL(it->service_url,id).c_str());
    if(url_inf->storageSystemInfo && url_inf->storageSystemInfo->value) {
      // ????????
    };
    SEFiles::iterator f = files->begin();
    for(;f!=files->end();++f) {
      odlog(VERBOSE)<<"srmRm: file: "<<f->id()<<std::endl;
      if(id == f->id()) {
        odlog(VERBOSE)<<"srmRm: matched"<<std::endl;
        if(acl_top_flags ||
           (f->check_acl(it->c->identity()) & FILE_ACC_DELETE)) {
          odlog(VERBOSE)<<"srmRm: allowed"<<std::endl;
          if(!(f->pinned())) {
            it->se->delete_file(*f);
            statuses[n]->status->statusCode=
                            SRMv2__TStatusCode__SRM_USCORESUCCESS;
          };
        };
      };
    };
  };
  resp.srmRmResponse->returnStatus->statusCode=
                         SRMv2__TStatusCode__SRM_USCORESUCCESS;
  resp.srmRmResponse->arrayOfFileStatuses->__sizesurlReturnStatusArray=n;
  return SOAP_OK;
}
 
 
int SRMv2__srmSetPermission(struct soap* sp, SRMv2__srmSetPermissionRequest *req, struct SRMv2__srmSetPermissionResponse_ &resp) {
  HTTP_SRM* it = (HTTP_SRM*)(sp->user);
  // Initialize default error response
  resp.srmSetPermissionResponse=soap_new_SRMv2__srmSetPermissionResponse(sp,-1);
  if(resp.srmSetPermissionResponse == NULL) return SOAP_OK;
  resp.srmSetPermissionResponse->soap_default(sp);
  resp.srmSetPermissionResponse->returnStatus=soap_new_SRMv2__TReturnStatus(sp,-1);
  if(resp.srmSetPermissionResponse->returnStatus == NULL) return SOAP_OK;
  resp.srmSetPermissionResponse->returnStatus->soap_default(sp);
  resp.srmSetPermissionResponse->returnStatus->statusCode=SRMv2__TStatusCode__SRM_USCOREFAILURE;
  if(req == NULL) return SOAP_OK;
  if(req->path == NULL) return SOAP_OK;
  if(req->path->SURLOrStFN == NULL) return SOAP_OK;
  if(req->path->SURLOrStFN->value == NULL) return SOAP_OK;
  const char* id = req->path->SURLOrStFN->value;
  SEFiles* files = it->se->files();
  int acl_top_flags =
               (files->check_acl(it->c->identity()) | it->se->check_acl()) &
               FILE_ACC_WRITE_META;
  acl_top_flags=acl_top_flags?0:(FILE_ACC_WRITE_META);
  files->acquire();
  SEFiles::iterator f = find_file(id,files,it->c->identity(),acl_top_flags);
  if(f == files->end()) {
    files->release();
    return SOAP_OK;
  };
  std::string acl;
  if(f->read_acl(AuthUser(),acl) != 0) {
    files->release();
    return SOAP_OK;
  };
  ObjectAccessGACL o_g(acl.c_str());
  ObjectAccessSRMv2 o_s(o_g);
  SRMv2__TUserID uid; uid.soap_default(sp);
  uid.value=soap_strdup(sp,f->creator().c_str());
  switch(req->permissionType) {
    case SRMv2__TPermissionType__ADD:
      o_s.modify_add(&uid,req->ownerPermission,req->userPermission,
                     req->groupPermission,req->otherPermission);
      break;
    case SRMv2__TPermissionType__REMOVE:
      o_s.modify_remove(&uid,req->ownerPermission,req->userPermission,
                     req->groupPermission,req->otherPermission);
      break;
    case SRMv2__TPermissionType__CHANGE:
      o_s.modify_set(&uid,req->ownerPermission,req->userPermission,
                     req->groupPermission,req->otherPermission);
      break;
    default:
      files->release();
      return SOAP_OK;
  };
  ObjectAccessGACL o_g_(o_s);
  o_g_.get(acl);
  if(f->write_acl(AuthUser(),acl.c_str()) != 0) {
    files->release();
    return SOAP_OK;
  };
  files->release();
  resp.srmSetPermissionResponse->returnStatus->statusCode=SRMv2__TStatusCode__SRM_USCORESUCCESS;
  return SOAP_OK;
}

int SRMv2__srmRmdir(struct soap* sp, SRMv2__srmRmdirRequest *req, struct SRMv2__srmRmdirResponse_ &resp) {
  HTTP_SRM* it = (HTTP_SRM*)(sp->user);
  // Initialize default error response
  resp.srmRmdirResponse = soap_new_SRMv2__srmRmdirResponse(sp,-1);
  if(resp.srmRmdirResponse == NULL) return SOAP_OK;
  resp.srmRmdirResponse->soap_default(sp);
  resp.srmRmdirResponse->returnStatus=soap_new_SRMv2__TReturnStatus(sp,-1);
  if(resp.srmRmdirResponse->returnStatus == NULL) return SOAP_OK;
  resp.srmRmdirResponse->returnStatus->soap_default(sp);
  resp.srmRmdirResponse->returnStatus->statusCode=SRMv2__TStatusCode__SRM_USCOREFAILURE;
  if(req == NULL) return SOAP_OK;
  if(req->directoryPath == NULL) return SOAP_OK;
  if(req->directoryPath->SURLOrStFN == NULL) return SOAP_OK;
  if(req->directoryPath->SURLOrStFN->value == NULL) return SOAP_OK;
  if((!(req->recursive)) || (!*(req->recursive))) {
    resp.srmRmdirResponse->returnStatus->statusCode=SRMv2__TStatusCode__SRM_USCORESUCCESS;
    return SOAP_OK;
  };
  std::string name = req->directoryPath->SURLOrStFN->value;
  while(name.length()) {
    if(name[name.length()-1] != '/') break;
    name.resize(name.length()-1);
  };
  name+='/';
  // Find all corresponding files and delete them
  SEFiles* files = it->se->files();
  // Top level access
  int acl_top_flags = (files->check_acl(it->c->identity()) | 
                         it->se->check_acl()) & FILE_ACC_DELETE;
  SEFiles::iterator f;
  files->acquire();
  f=files->begin();
  bool failed = false;
  for(;f!=files->end();++f) {
    odlog(VERBOSE)<<"srmRmdir: file: "<<f->id()<<std::endl;
    if(strncmp(name.c_str(),f->id(),name.length()) == 0) {
      odlog(DEBUG)<<"srmRmdir: matched"<<std::endl;
      if(acl_top_flags ||
         (f->check_acl(it->c->identity()) & FILE_ACC_DELETE)) {
        odlog(VERBOSE)<<"srmRmdir: allowed"<<std::endl;
        if(!(f->pinned())) {
          it->se->delete_file(*f);
        } else { failed=true; };
      } else { failed=true; };
    };
  };
  if(!failed) resp.srmRmdirResponse->returnStatus->statusCode=SRMv2__TStatusCode__SRM_USCORESUCCESS;
  return SOAP_OK;
}

// --------------------------------------------------------------
// Non-supported methods

int SRMv2__srmRemoveFiles(struct soap* sp, SRMv2__srmRemoveFilesRequest *req, struct SRMv2__srmRemoveFilesResponse_ &resp) {
  resp.srmRemoveFilesResponse = soap_new_SRMv2__srmRemoveFilesResponse(sp,-1);
  resp.srmRemoveFilesResponse->returnStatus=soap_new_SRMv2__TReturnStatus(sp,-1);
  resp.srmRemoveFilesResponse->returnStatus->statusCode=SRMv2__TStatusCode__SRM_USCORENOT_USCORESUPPORTED;
  return SOAP_OK;
}

int SRMv2__srmReserveSpace(struct soap* sp, SRMv2__srmReserveSpaceRequest *req, struct SRMv2__srmReserveSpaceResponse_ &resp) {
  resp.srmReserveSpaceResponse = soap_new_SRMv2__srmReserveSpaceResponse(sp,-1);
  resp.srmReserveSpaceResponse->returnStatus=soap_new_SRMv2__TReturnStatus(sp,-1);
  resp.srmReserveSpaceResponse->returnStatus->statusCode=SRMv2__TStatusCode__SRM_USCORENOT_USCORESUPPORTED;
  return SOAP_OK;
}

int SRMv2__srmReleaseSpace(struct soap* sp, SRMv2__srmReleaseSpaceRequest *req, struct SRMv2__srmReleaseSpaceResponse_ &resp) {
  resp.srmReleaseSpaceResponse = soap_new_SRMv2__srmReleaseSpaceResponse(sp,-1);
  resp.srmReleaseSpaceResponse->returnStatus=soap_new_SRMv2__TReturnStatus(sp,-1);
  resp.srmReleaseSpaceResponse->returnStatus->statusCode=SRMv2__TStatusCode__SRM_USCORENOT_USCORESUPPORTED;
  return SOAP_OK;
}


int SRMv2__srmUpdateSpace(struct soap* sp, SRMv2__srmUpdateSpaceRequest *req, struct SRMv2__srmUpdateSpaceResponse_ &resp) {
  resp.srmUpdateSpaceResponse = soap_new_SRMv2__srmUpdateSpaceResponse(sp,-1);
  resp.srmUpdateSpaceResponse->returnStatus=soap_new_SRMv2__TReturnStatus(sp,-1);
  resp.srmUpdateSpaceResponse->returnStatus->statusCode=SRMv2__TStatusCode__SRM_USCORENOT_USCORESUPPORTED;
  return SOAP_OK;
}


int SRMv2__srmCompactSpace(struct soap* sp, SRMv2__srmCompactSpaceRequest *req, struct SRMv2__srmCompactSpaceResponse_ &resp) {
  resp.srmCompactSpaceResponse = soap_new_SRMv2__srmCompactSpaceResponse(sp,-1);
  resp.srmCompactSpaceResponse->returnStatus=soap_new_SRMv2__TReturnStatus(sp,-1);
  resp.srmCompactSpaceResponse->returnStatus->statusCode=SRMv2__TStatusCode__SRM_USCORENOT_USCORESUPPORTED;
  return SOAP_OK;
}


int SRMv2__srmGetSpaceMetaData(struct soap* sp, SRMv2__srmGetSpaceMetaDataRequest *req, struct SRMv2__srmGetSpaceMetaDataResponse_ &resp) {
  resp.srmGetSpaceMetaDataResponse = soap_new_SRMv2__srmGetSpaceMetaDataResponse(sp,-1);
  resp.srmGetSpaceMetaDataResponse->returnStatus=soap_new_SRMv2__TReturnStatus(sp,-1);
  resp.srmGetSpaceMetaDataResponse->returnStatus->statusCode=SRMv2__TStatusCode__SRM_USCORENOT_USCORESUPPORTED;
  return SOAP_OK;
}


int SRMv2__srmChangeFileStorageType(struct soap* sp, SRMv2__srmChangeFileStorageTypeRequest *req, struct SRMv2__srmChangeFileStorageTypeResponse_ &resp) {
  resp.srmChangeFileStorageTypeResponse = soap_new_SRMv2__srmChangeFileStorageTypeResponse(sp,-1);
  resp.srmChangeFileStorageTypeResponse->returnStatus=soap_new_SRMv2__TReturnStatus(sp,-1);
  resp.srmChangeFileStorageTypeResponse->returnStatus->statusCode=SRMv2__TStatusCode__SRM_USCORENOT_USCORESUPPORTED;
  return SOAP_OK;
}


int SRMv2__srmGetSpaceToken(struct soap* sp, SRMv2__srmGetSpaceTokenRequest *req, struct SRMv2__srmGetSpaceTokenResponse_ &resp) {
  resp.srmGetSpaceTokenResponse = soap_new_SRMv2__srmGetSpaceTokenResponse(sp,-1);
  resp.srmGetSpaceTokenResponse->returnStatus=soap_new_SRMv2__TReturnStatus(sp,-1);
  resp.srmGetSpaceTokenResponse->returnStatus->statusCode=SRMv2__TStatusCode__SRM_USCORENOT_USCORESUPPORTED;
  return SOAP_OK;
}


int SRMv2__srmReassignToUser(struct soap* sp, SRMv2__srmReassignToUserRequest *req, struct SRMv2__srmReassignToUserResponse_ &resp) {
  resp.srmReassignToUserResponse = soap_new_SRMv2__srmReassignToUserResponse(sp,-1);
  resp.srmReassignToUserResponse->returnStatus=soap_new_SRMv2__TReturnStatus(sp,-1);
  resp.srmReassignToUserResponse->returnStatus->statusCode=SRMv2__TStatusCode__SRM_USCORENOT_USCORESUPPORTED;
  return SOAP_OK;
}


int SRMv2__srmCheckPermission(struct soap* sp, SRMv2__srmCheckPermissionRequest *req, struct SRMv2__srmCheckPermissionResponse_ &resp) {
  resp.srmCheckPermissionResponse = soap_new_SRMv2__srmCheckPermissionResponse(sp,-1);
  resp.srmCheckPermissionResponse->returnStatus=soap_new_SRMv2__TReturnStatus(sp,-1);
  resp.srmCheckPermissionResponse->returnStatus->statusCode=SRMv2__TStatusCode__SRM_USCORENOT_USCORESUPPORTED;
  return SOAP_OK;
}


int SRMv2__srmMkdir(struct soap* sp, SRMv2__srmMkdirRequest *req, struct SRMv2__srmMkdirResponse_ &resp) {
  resp.srmMkdirResponse = soap_new_SRMv2__srmMkdirResponse(sp,-1);
  resp.srmMkdirResponse->returnStatus=soap_new_SRMv2__TReturnStatus(sp,-1);
  resp.srmMkdirResponse->returnStatus->statusCode=SRMv2__TStatusCode__SRM_USCORENOT_USCORESUPPORTED;
  return SOAP_OK;
}


int SRMv2__srmMv(struct soap* sp, SRMv2__srmMvRequest *req, struct SRMv2__srmMvResponse_ &resp) {
  resp.srmMvResponse = soap_new_SRMv2__srmMvResponse(sp,-1);
  resp.srmMvResponse->returnStatus=soap_new_SRMv2__TReturnStatus(sp,-1);
  resp.srmMvResponse->returnStatus->statusCode=SRMv2__TStatusCode__SRM_USCORENOT_USCORESUPPORTED;
  return SOAP_OK;
}


int SRMv2__srmPrepareToPut(struct soap* sp, SRMv2__srmPrepareToPutRequest *req, struct SRMv2__srmPrepareToPutResponse_ &resp) {
  resp.srmPrepareToPutResponse = soap_new_SRMv2__srmPrepareToPutResponse(sp,-1);
  resp.srmPrepareToPutResponse->returnStatus=soap_new_SRMv2__TReturnStatus(sp,-1);
  resp.srmPrepareToPutResponse->returnStatus->statusCode=SRMv2__TStatusCode__SRM_USCORENOT_USCORESUPPORTED;
  return SOAP_OK;
}


int SRMv2__srmPrepareToGet(struct soap* sp, SRMv2__srmPrepareToGetRequest *req, struct SRMv2__srmPrepareToGetResponse_ &resp) {
  resp.srmPrepareToGetResponse = soap_new_SRMv2__srmPrepareToGetResponse(sp,-1);
  resp.srmPrepareToGetResponse->returnStatus=soap_new_SRMv2__TReturnStatus(sp,-1);
  resp.srmPrepareToGetResponse->returnStatus->statusCode=SRMv2__TStatusCode__SRM_USCORENOT_USCORESUPPORTED;
  return SOAP_OK;
}


int SRMv2__srmCopy(struct soap* sp, SRMv2__srmCopyRequest *req, struct SRMv2__srmCopyResponse_ &resp) {
  resp.srmCopyResponse = soap_new_SRMv2__srmCopyResponse(sp,-1);
  resp.srmCopyResponse->returnStatus=soap_new_SRMv2__TReturnStatus(sp,-1);
  resp.srmCopyResponse->returnStatus->statusCode=SRMv2__TStatusCode__SRM_USCORENOT_USCORESUPPORTED;
  return SOAP_OK;
}


int SRMv2__srmReleaseFiles(struct soap* sp, SRMv2__srmReleaseFilesRequest *req, struct SRMv2__srmReleaseFilesResponse_ &resp) {
  resp.srmReleaseFilesResponse = soap_new_SRMv2__srmReleaseFilesResponse(sp,-1);
  resp.srmReleaseFilesResponse->returnStatus=soap_new_SRMv2__TReturnStatus(sp,-1);
  resp.srmReleaseFilesResponse->returnStatus->statusCode=SRMv2__TStatusCode__SRM_USCORENOT_USCORESUPPORTED;
  return SOAP_OK;
}


int SRMv2__srmPutDone(struct soap* sp, SRMv2__srmPutDoneRequest*, struct SRMv2__srmPutDoneResponse_ &resp) {
  resp.srmPutDoneResponse = soap_new_SRMv2__srmPutDoneResponse(sp,-1);
  resp.srmPutDoneResponse->returnStatus=soap_new_SRMv2__TReturnStatus(sp,-1);
  resp.srmPutDoneResponse->returnStatus->statusCode=SRMv2__TStatusCode__SRM_USCORENOT_USCORESUPPORTED;
  return SOAP_OK;
}


int SRMv2__srmAbortRequest(struct soap* sp, SRMv2__srmAbortRequestRequest *req, struct SRMv2__srmAbortRequestResponse_ &resp) {
  resp.srmAbortRequestResponse = soap_new_SRMv2__srmAbortRequestResponse(sp,-1);
  resp.srmAbortRequestResponse->returnStatus=soap_new_SRMv2__TReturnStatus(sp,-1);
  resp.srmAbortRequestResponse->returnStatus->statusCode=SRMv2__TStatusCode__SRM_USCORENOT_USCORESUPPORTED;
  return SOAP_OK;
}


int SRMv2__srmAbortFiles(struct soap* sp, SRMv2__srmAbortFilesRequest *req, struct SRMv2__srmAbortFilesResponse_ &resp) {
  resp.srmAbortFilesResponse = soap_new_SRMv2__srmAbortFilesResponse(sp,-1);
  resp.srmAbortFilesResponse->returnStatus=soap_new_SRMv2__TReturnStatus(sp,-1);
  resp.srmAbortFilesResponse->returnStatus->statusCode=SRMv2__TStatusCode__SRM_USCORENOT_USCORESUPPORTED;
  return SOAP_OK;
}


int SRMv2__srmSuspendRequest(struct soap* sp, SRMv2__srmSuspendRequestRequest *req, struct SRMv2__srmSuspendRequestResponse_ &resp) {
  resp.srmSuspendRequestResponse = soap_new_SRMv2__srmSuspendRequestResponse(sp,-1);
  resp.srmSuspendRequestResponse->returnStatus=soap_new_SRMv2__TReturnStatus(sp,-1);
  resp.srmSuspendRequestResponse->returnStatus->statusCode=SRMv2__TStatusCode__SRM_USCORENOT_USCORESUPPORTED;
  return SOAP_OK;
}


int SRMv2__srmResumeRequest(struct soap* sp, SRMv2__srmResumeRequestRequest *req, struct SRMv2__srmResumeRequestResponse_ &resp) {
  resp.srmResumeRequestResponse = soap_new_SRMv2__srmResumeRequestResponse(sp,-1);
  resp.srmResumeRequestResponse->returnStatus=soap_new_SRMv2__TReturnStatus(sp,-1);
  resp.srmResumeRequestResponse->returnStatus->statusCode=SRMv2__TStatusCode__SRM_USCORENOT_USCORESUPPORTED;
  return SOAP_OK;
}


int SRMv2__srmStatusOfGetRequest(struct soap* sp, SRMv2__srmStatusOfGetRequestRequest *req, struct SRMv2__srmStatusOfGetRequestResponse_ &resp) {
  resp.srmStatusOfGetRequestResponse = soap_new_SRMv2__srmStatusOfGetRequestResponse(sp,-1);
  resp.srmStatusOfGetRequestResponse->returnStatus=soap_new_SRMv2__TReturnStatus(sp,-1);
  resp.srmStatusOfGetRequestResponse->returnStatus->statusCode=SRMv2__TStatusCode__SRM_USCORENOT_USCORESUPPORTED;
  return SOAP_OK;
}


int SRMv2__srmStatusOfPutRequest(struct soap* sp, SRMv2__srmStatusOfPutRequestRequest *req, struct SRMv2__srmStatusOfPutRequestResponse_ &resp) {
  resp.srmStatusOfPutRequestResponse = soap_new_SRMv2__srmStatusOfPutRequestResponse(sp,-1);
  resp.srmStatusOfPutRequestResponse->returnStatus=soap_new_SRMv2__TReturnStatus(sp,-1);
  resp.srmStatusOfPutRequestResponse->returnStatus->statusCode=SRMv2__TStatusCode__SRM_USCORENOT_USCORESUPPORTED;
  return SOAP_OK;
}


int SRMv2__srmStatusOfCopyRequest(struct soap* sp, SRMv2__srmStatusOfCopyRequestRequest *req, struct SRMv2__srmStatusOfCopyRequestResponse_ &resp) {
  resp.srmStatusOfCopyRequestResponse = soap_new_SRMv2__srmStatusOfCopyRequestResponse(sp,-1);
  resp.srmStatusOfCopyRequestResponse->returnStatus=soap_new_SRMv2__TReturnStatus(sp,-1);
  resp.srmStatusOfCopyRequestResponse->returnStatus->statusCode=SRMv2__TStatusCode__SRM_USCORENOT_USCORESUPPORTED;
  return SOAP_OK;
}


int SRMv2__srmGetRequestSummary(struct soap* sp, SRMv2__srmGetRequestSummaryRequest *req, struct SRMv2__srmGetRequestSummaryResponse_ &resp) {
  resp.srmGetRequestSummaryResponse = soap_new_SRMv2__srmGetRequestSummaryResponse(sp,-1);
  resp.srmGetRequestSummaryResponse->returnStatus=soap_new_SRMv2__TReturnStatus(sp,-1);
  resp.srmGetRequestSummaryResponse->returnStatus->statusCode=SRMv2__TStatusCode__SRM_USCORENOT_USCORESUPPORTED;
  return SOAP_OK;
}


int SRMv2__srmExtendFileLifeTime(struct soap* sp, SRMv2__srmExtendFileLifeTimeRequest *req, struct SRMv2__srmExtendFileLifeTimeResponse_ &resp) {
  resp.srmExtendFileLifeTimeResponse = soap_new_SRMv2__srmExtendFileLifeTimeResponse(sp,-1);
  resp.srmExtendFileLifeTimeResponse->returnStatus=soap_new_SRMv2__TReturnStatus(sp,-1);
  resp.srmExtendFileLifeTimeResponse->returnStatus->statusCode=SRMv2__TStatusCode__SRM_USCORENOT_USCORESUPPORTED;
  return SOAP_OK;
}


int SRMv2__srmGetRequestID(struct soap* sp, SRMv2__srmGetRequestIDRequest *req, struct SRMv2__srmGetRequestIDResponse_ &resp) {
  resp.srmGetRequestIDResponse = soap_new_SRMv2__srmGetRequestIDResponse(sp,-1);
  resp.srmGetRequestIDResponse->returnStatus=soap_new_SRMv2__TReturnStatus(sp,-1);
  resp.srmGetRequestIDResponse->returnStatus->statusCode=SRMv2__TStatusCode__SRM_USCORENOT_USCORESUPPORTED;
  return SOAP_OK;
}

