#include "../../std.h"

#include "permission_srm.h"

void PermissionSRMv2::reset(void) {
  Permission::set(object,Permission::create,deny);
  Permission::set(object,Permission::read,deny);
  Permission::set(object,Permission::write,deny);
  Permission::set(object,Permission::extend,deny);
  Permission::set(object,Permission::reduce,deny);
  Permission::set(object,Permission::remove,deny);
  Permission::set(object,Permission::info,deny);
  Permission::set(metadata,Permission::create,deny);
  Permission::set(metadata,Permission::read,deny);
  Permission::set(metadata,Permission::write,deny);
  Permission::set(metadata,Permission::extend,deny);
  Permission::set(metadata,Permission::reduce,deny);
  Permission::set(metadata,Permission::remove,deny);
  Permission::set(metadata,Permission::info,deny);
  Permission::set(permissions,Permission::create,deny);
  Permission::set(permissions,Permission::read,deny);
  Permission::set(permissions,Permission::write,deny);
  Permission::set(permissions,Permission::extend,deny);
  Permission::set(permissions,Permission::reduce,deny);
  Permission::set(permissions,Permission::remove,deny);
  Permission::set(permissions,Permission::info,deny);
}

PermissionSRMv2::PermissionSRMv2(void) {
  reset();
}

PermissionSRMv2::PermissionSRMv2(SRMv2__TPermissionMode p) {
  reset();
  set(p);
}

PermissionSRMv2::PermissionSRMv2(const Permission& p):Permission(p) {
}

PermissionSRMv2::~PermissionSRMv2(void) {
}

Permission* PermissionSRMv2::duplicate(void) const {
  return new PermissionSRMv2(*this);
}

bool PermissionSRMv2::allowRead(void) {
  return Permission::get(object,read,allow); 
}

bool PermissionSRMv2::allowWrite(void) {
  return Permission::get(object,write,allow) || 
         Permission::get(object,extend,allow) ||
         Permission::get(object,reduce,allow);
}

bool PermissionSRMv2::allowExecute(void) {
  return false;
}

void PermissionSRMv2::allowRead(bool v) {
  if(v) {
    Permission::set(object,read,allow);
  } else {
    Permission::set(object,read,deny);
  };
}

void PermissionSRMv2::allowWrite(bool v) {
  if(v) {
    Permission::set(object,write,allow);
    Permission::set(object,extend,allow);
    Permission::set(object,reduce,allow);
  } else {
    Permission::set(object,write,deny);
    Permission::set(object,extend,deny);
    Permission::set(object,reduce,deny);
  };
}

void PermissionSRMv2::allowExecute(bool v) {
  if(v) {
  } else {
  };
}

SRMv2__TPermissionMode PermissionSRMv2::get() {
  bool r = allowRead();
  bool w = allowWrite();
  bool x = allowExecute();
  if(r && w && x) return SRMv2__TPermissionMode__RWX;
  if(r && w) return SRMv2__TPermissionMode__RW;
  if(r && x) return SRMv2__TPermissionMode__RX;
  if(w && x) return SRMv2__TPermissionMode__WX;
  if(r) return SRMv2__TPermissionMode__R;
  if(w) return SRMv2__TPermissionMode__W;
  if(x) return SRMv2__TPermissionMode__X;
  return SRMv2__TPermissionMode__None;
}

void PermissionSRMv2::set(SRMv2__TPermissionMode p) {
  bool r = false;
  bool w = false;
  bool x = false;
  switch(p) {
    case SRMv2__TPermissionMode__R: r=true; break;
    case SRMv2__TPermissionMode__W: w=true; break;
    case SRMv2__TPermissionMode__X: x=true; break;
    case SRMv2__TPermissionMode__RW: r=true; w=true; break;
    case SRMv2__TPermissionMode__RX: r=true; x=true; break;
    case SRMv2__TPermissionMode__WX: w=true; x=true; break;
    case SRMv2__TPermissionMode__RWX: r=true; w=true; x=true; break;
  };
  allowRead(r); allowWrite(w); allowExecute(x);
}

void PermissionSRMv2::add(SRMv2__TPermissionMode p) {
  bool r = false;
  bool w = false;
  bool x = false;
  switch(p) {
    case SRMv2__TPermissionMode__R: r=true; break;
    case SRMv2__TPermissionMode__W: w=true; break;
    case SRMv2__TPermissionMode__X: x=true; break;
    case SRMv2__TPermissionMode__RW: r=true; w=true; break;
    case SRMv2__TPermissionMode__RX: r=true; x=true; break;
    case SRMv2__TPermissionMode__WX: w=true; x=true; break;
    case SRMv2__TPermissionMode__RWX: r=true; w=true; x=true; break;
  };
  if(r) allowRead(true);
  if(w) allowWrite(true);
  if(x) allowExecute(true);
}

void PermissionSRMv2::remove(SRMv2__TPermissionMode p) {
  bool r = false;
  bool w = false;
  bool x = false;
  switch(p) {
    case SRMv2__TPermissionMode__R: r=true; break;
    case SRMv2__TPermissionMode__W: w=true; break;
    case SRMv2__TPermissionMode__X: x=true; break;
    case SRMv2__TPermissionMode__RW: r=true; w=true; break;
    case SRMv2__TPermissionMode__RX: r=true; x=true; break;
    case SRMv2__TPermissionMode__WX: w=true; x=true; break;
    case SRMv2__TPermissionMode__RWX: r=true; w=true; x=true; break;
  };
  if(r) allowRead(false);
  if(w) allowWrite(false);
  if(x) allowExecute(false);
}

