// util.h includes proper gacl file and fixes few compatibility 
// issues between old gacl and gridsite

#include <string>
#include <list>

#include "util.h"
#include "../../auth/gacl_auth.h"

#ifdef NG_VOMS
  #define HAVE_VOMS
  #include <voms_api.h>
#else
 #ifdef EDG_VOMS
  #define HAVE_VOMS
  #include <voms_api.h>
 #else
  #undef HAVE_VOMS
 #endif
#endif

GACLperm GACLtestFileAclForVOMS(const char *filename,const AuthUser& user,bool gacl_itself = false);

void GACLextractAdmin(const char *filename,std::list<std::string>& identities,bool gacl_itself = false);

void GACLextractAdmin(GACLacl* acl,std::list<std::string>& identities);

