#include "../std.h"
#include "conf.h"

static char* default_config_file = DEFAULT_CONFIG_FILE;
static char* default_config_file_rel = DEFAULT_CONFIG_FILE;
static char* default_central_config_file = DEFAULT_CENTRAL_CONFIG_FILE;
static char* default_central_config_file2 = DEFAULT_CENTRAL_CONFIG_FILE2;
char* config_file = NULL;


bool config_open_gridftp(std::ifstream &cfile) {
  std::string config_name;
  read_env_vars(true);
  if(config_file) {
    config_name=config_file;
  } else if(!central_configuration) {
    if(nordugrid_loc.length() == 0) {
      config_name=default_config_file;
    } else {
      config_name=nordugrid_loc+default_config_file_rel;
    };
  } else {
    struct stat st;
    if(stat(default_central_config_file,&st) == 0) {
      config_name=default_central_config_file;
    } else {
      config_name=default_central_config_file2;
    };
  };
  return config_open(cfile,config_name);
}

void config_strip(std::string &rest) {
  int n=rest.find_first_not_of(" \t",0);
  if(n>0) rest.erase(0,n);
}

