#include "../std.h"
#include "../config/config_map.h"
#include "../transfer/replica_utils.h"
#include "../transfer/replica.h"
#include "../misc/url_options.h"
#include "../misc/checksum.h"
#include "../misc/log_time.h"

#include "datapoint.h"


DataPointRC::DataPointRC(const char* u):DataPointMeta(u) {
  rc_mgr=NULL;
  if(u == NULL) return;
  if(strncasecmp("rc://",u,5)) return;
  if(!process_meta_url()) return;
  if(locations.size()) location=locations.begin();
  is_valid=true;
}

DataPoint* DataPointRC::CreateInstance(const char* u) {
  if(u == NULL) return NULL;
  if(strncasecmp("rc://",u,5)) return NULL;
  return new DataPointRC(u);
}

DataPointRC::~DataPointRC(void) {

}

/* perform resolve operation, which can take long time */
bool DataPointRC::meta_resolve(bool source) {
#ifdef HAVE_GLOBUS_REPLICA_CATALOG_H
    is_resolved=false;
    /* connect to RC server and replace locations with urls */
    is_metaexisting=false;
    if(!rc_mgr) rc_mgr = new RCManager(meta_service_url,"","");
    if(!(rc_mgr->is_open())) {
      odlog(ERROR)<<"Failed accessing Replica Catalog collection: "<<meta_service_url<<std::endl;
      delete rc_mgr; rc_mgr=NULL;
      return false;
    };
    std::list<RCLocation> *locs = new std::list<RCLocation>;
   /* !!!!! TODO - make sure results returned by rc_mgr are real results
      and not errors */ 
    odlog(DEBUG)<<"meta_resolve: lfn: "<<meta_lfn<<std::endl;
    if(source) {
      odlog(DEBUG)<<"meta_resolve: for source"<<std::endl;
      if(!rc_mgr->GetLocations("",*locs,meta_lfn.c_str())) { 
        odlog(ERROR)<<"Locations not found: "<<meta_service_url<<std::endl;
        delete locs; delete rc_mgr; rc_mgr=NULL; return false;
      };
      is_metaexisting=true;
    }
    else {
      odlog(DEBUG)<<"meta_resolve: for destination"<<std::endl;
      if(!(rc_mgr->GetLocations("",*locs))) {
        odlog(ERROR)<<"Locations not found: "<<meta_service_url<<std::endl;
        delete locs; delete rc_mgr; rc_mgr=NULL; return false;
      };
    };
    if(locations.size() == 0) { // no predefined locations - accept all found
      std::list<RCLocation>::iterator rcloc;
      for(rcloc=locs->begin();rcloc!=locs->end();++rcloc) {
        locations.push_back(Location(rcloc->name,rcloc->url+meta_lfn));
      };
      for(std::list<Location>::iterator loc=locations.begin();loc!=locations.end();++loc) {
          if(common_url_options.length() != 0)
            add_url_options(loc->url,common_url_options.c_str(),-1);
      };
    }
    else {
      std::list<Location>::iterator loc = locations.begin();
      std::list<RCLocation>::iterator rcloc;
      for(;loc!=locations.end();) {
        bool found = false;
        std::string name = loc->meta;
        std::string options = "";
        std::string::size_type n = name.find(';'); // remove options from name for clean compare
        if(n != std::string::npos) {
          options=name.substr(n+1);
          name.resize(n);
        };
        for(rcloc=locs->begin();rcloc!=locs->end();++rcloc) {
          if(rcloc->name != name) continue;
          loc->url=rcloc->url+meta_lfn;
          loc->meta=name; // effectively strips options off :)
          loc->existing=true; // if it was addded manualy, now it is resolved
          locs->erase(rcloc);
          if(common_url_options.length() != 0)
            add_url_options(loc->url,common_url_options.c_str(),-1);
          add_url_options(loc->url,options.c_str(),-1);
          found=true;
          break;
        };
        if(!found) { 
          if(loc->existing) { loc=locations.erase(loc); } // remove resolved
          else { ++loc; }; // and keep manual
        }
        else { ++loc; };
      };
    };
    /* obtain metadata */
    RCFile file(meta_lfn,0,false,NULL,false,0,false);
    if(!rc_mgr->GetFile(file)) {
      if(source) {
        odlog(DEBUG)<<"File "<<meta_lfn<<" does not exist or has no metadata"<<std::endl;
      };
    }
    else {
      is_metaexisting=true;
      odlog(DEBUG)<<"meta_get_data: obtained metadata"<<std::endl;
      if(!meta_checksum_valid) meta_checksum(file.get_checksum());
      if(!meta_size_valid) meta_size(file.get_size());
      if(!meta_created_valid) meta_created(file.get_timestamp());
    };
    odlog(DEBUG)<<"meta_get_data: checksum: "<<meta_checksum()<<std::endl;
    odlog(DEBUG)<<"meta_get_data: size: "<<meta_size()<<std::endl;
    odlog(DEBUG)<<"meta_get_data: created: "<<meta_created()<<std::endl;
    delete locs; delete rc_mgr; rc_mgr=NULL;
    location=locations.begin();
    is_resolved=true;
    return true;
#else
    return false;
#endif
}

bool DataPointRC::meta_preregister(bool replication,bool force) {
#ifdef HAVE_GLOBUS_REPLICA_CATALOG_H
    odlog(DEBUG)<<"meta_preregister: is rc"<<std::endl;
    if(replication) { /* replicating inside same lfn */
      if(!is_metaexisting) { /* for replication it must be there */
        odlog(ERROR)<<"LFN is missing in replica (needed for replication)"<<std::endl;
        return false;
      };
      return true;
    };
    if(is_metaexisting) { /* algorithm require this to be new file */
      if(!force) { /* unless we have dead SE */
        odlog(ERROR)<<"LFN already exists in replica (should not for new file)"<<std::endl;
        return false;
      };
    };
    if(!meta_size_valid) {
      odlog(ERROR)<<"Not enough metadata available for lfn creation"<<std::endl;
      return false;
    };
    rc_mgr = new RCManager(meta_service_url,"","");
    if(!(rc_mgr->is_open())) {
      odlog(ERROR)<<"Failed accessing Replica Catalog collection: "<<meta_service_url<<std::endl;
      delete rc_mgr; rc_mgr=NULL; return false;
    };
    odlog(DEBUG)<<"meta_preregister: creating RCFile"<<std::endl;
    RCFile file(meta_lfn,
           meta_size(),meta_size_valid,
           meta_checksum(),meta_checksum_valid,
           meta_created(),meta_created_valid);
/* !!! TODO - make sure results returned by rc_mgr are real results
      and not errors */
    odlog(DEBUG)<<"meta_preregister: creating lfn in RC"<<std::endl;
    if(!rc_mgr->AddFile(file,!force)) {
      if(!force) {
        odlog(ERROR)<<"Failed to create lfn in RC"<<std::endl;
        delete rc_mgr; rc_mgr=NULL; return false;
      };
      // if force, then just add missing metadata
      if(!rc_mgr->UpdateFile(file)) {
        odlog(ERROR)<<"Failed to update lfn in RC"<<std::endl;
        delete rc_mgr; rc_mgr=NULL; return false;
      };
    };
    delete rc_mgr; rc_mgr=NULL;
    is_metaexisting=true;
    return true;
#else
    return false;
#endif
}

bool DataPointRC::meta_postregister(bool replication,bool failure) {
#ifdef HAVE_GLOBUS_REPLICA_CATALOG_H
    if(!is_metaexisting) { 
      odlog(ERROR)<<"File was not yet registered in replica"<<std::endl;
      return false;
    };
    rc_mgr = new RCManager(meta_service_url,"","");
    if(!(rc_mgr->is_open())) {
      odlog(ERROR)<<"Failed accessing Replica Catalog collection: "<<meta_service_url<<std::endl;
      delete rc_mgr; rc_mgr=NULL; return false;
    };
    odlog(DEBUG)<<"meta_postregister: updating RCFile"<<std::endl;
    RCFile file(meta_lfn,
           meta_size(),meta_size_valid,
           meta_checksum(),meta_checksum_valid,
           meta_created(),meta_created_valid);
/* !!! TODO - make sure results returned by rc_mgr are real results
      and not errors */
    if(!rc_mgr->UpdateFile(file)) {
      odlog(ERROR)<<"Failed to update lfn attributes in RC"<<std::endl;
      rc_mgr->RemoveFile(file);
      delete rc_mgr; rc_mgr=NULL; return false;
    };
    std::string host = location->meta;
    odlog(DEBUG)<<"meta_postregister: creating pfn in RC"<<std::endl;
    std::string loc_url("*");
    if(!(location->existing)) {
      // manually added location possibly need registration
      loc_url=location->url;
      loc_url.resize(location->url.length()-meta_lfn.length());
    };
    if(!rc_mgr->AddFileLocation(file,host,loc_url.c_str(),true)) {
      odlog(ERROR)<<"Failed to create pfn in RC"<<std::endl;
      // delete 
      if(!replication) rc_mgr->RemoveFile(file);
      delete rc_mgr; rc_mgr=NULL; return false;
    };
    delete rc_mgr; rc_mgr=NULL;
    return true;
#else
    return false;
#endif
}

bool DataPointRC::meta_preunregister(bool replication) {
#ifdef HAVE_GLOBUS_REPLICA_CATALOG_H
  if(replication) return true;
  if(meta_unregister(true)) {
    is_metaexisting=false;
    return true;
  };
  return false;
#else
  return false;
#endif
}

bool DataPointRC::meta_unregister(bool all) {
#ifdef HAVE_GLOBUS_REPLICA_CATALOG_H
/* not fully implemented yet - all=true will remove logical file only */
    if(!all) {
      if(location == locations.end()) { 
        odlog(ERROR)<<"Location is missing"<<std::endl;
        return false;
      };
    };
    rc_mgr = new RCManager(meta_service_url,"","");
    if(!(rc_mgr->is_open())) {
      odlog(ERROR)<<"Failed accessing Replica Catalog collection: "<<meta_service_url<<std::endl;
      delete rc_mgr; rc_mgr=NULL; return false;
    };
    odlog(DEBUG)<<"meta_unregister: creating RCFile"<<std::endl;
    RCFile file(meta_lfn,0,false,0,false,0,false);
    if(all) {
      if(rc_mgr->RemoveFile(file) != true) {
        odlog(ERROR)<<"Failed to remove lfn in RC"<<std::endl;
        delete rc_mgr; rc_mgr=NULL; return false;
      };
    }
    else {
      if(rc_mgr->RemoveFileLocation(file,location->meta) != true) {
        odlog(ERROR)<<"Failed to remove pfn in RC"<<std::endl;
        delete rc_mgr; rc_mgr=NULL; return false;
      };
    };
    delete rc_mgr; rc_mgr=NULL;
    fix_unregistered(all);
    return true;
#else
  return false;
#endif
}

/* extract info from metacatalog url */
bool DataPointRC::process_meta_url(void) {
#ifdef HAVE_GLOBUS_REPLICA_CATALOG_H
  if(!strncasecmp(url.c_str(),"rc://",5)) {
    meta_service_url.resize(0); locations.clear(); meta_lfn.resize(0);
    std::string url_(url.c_str());
    if(!extract_RC_from_url(url_,meta_service_url)) {
      odlog(ERROR)<<"URL part to contact Replica Catalog is missing in "<<url<<std::endl;
      return false;
    };
    /* extract host and filename from url */
    const char* s=url_.c_str()+strlen(rc_url_head);
    const char* s_e = strchr(s,'/'); if(s_e == NULL) s_e=s+strlen(s);
    std::string host(s,s_e-s);
    if(host.length()) if(host[host.length()-1] == '@') host.resize(host.length()-1);
    odlog(DEBUG)<<"Location hosts: "<<host<<std::endl;
    std::string::size_type n=0;
    for(std::string::size_type nn=0;n<host.length();) {
      nn=host.find('|',n); if(nn == std::string::npos) nn=host.length();
      if(n == nn) { n++; continue; };
      if(host.c_str()[n] == ';') {
        common_url_options+=host.substr(n,nn-n);
      }
      else {
        std::string loc(host.c_str()+n,nn-n);
        locations.push_back(DataPointRC::Location(loc.c_str(),""));
      };
      n=nn+1;
    };
    if(common_url_options.length() != 0)
      if(common_url_options[0] == ';') 
        common_url_options.erase(0,1);
    const char* fname = NULL;
    if((*s_e) != 0) {
      std::string filename(s_e+1);
      extract_meta_attributes(filename);
      meta_lfn=filename;
      odlog(DEBUG)<<"Logical filename: "<<meta_lfn<<std::endl;
    };
    return true;
  };
  return false;
#else
  return false;
#endif
};

// obtain list of lfns and corresponding attributes
bool DataPointRC::list_files(std::list<DataPoint::FileInfo> &files,bool resolve) {
#ifdef HAVE_GLOBUS_REPLICA_CATALOG_H
    if(!rc_mgr) rc_mgr = new RCManager(meta_service_url,"","");
    if(!(rc_mgr->is_open())) {
      odlog(ERROR)<<"Failed accessing Replica Catalog collection: "<<meta_service_url<<std::endl;
      delete rc_mgr; rc_mgr=NULL;
      return false;
    };
    std::list<RCFile> rcfiles;
   /* !!!!! TODO - make sure results returned by rc_mgr are real results
      and not errors */
odlog(DEBUG)<<"list_files_rc: retrieving lfns"<<std::endl;
    if(!rc_mgr->ListFiles(rcfiles)) {
      odlog(ERROR)<<"Failed to list files: "<<meta_service_url<<std::endl;
      delete rc_mgr; rc_mgr=NULL; return false;
    };
    if(meta_lfn.length() == 0) {
      std::string tmp_rc_lfn = meta_lfn;
      bool result = true;
      for(std::list<RCFile>::iterator rcf=rcfiles.begin();rcf!=rcfiles.end();++rcf) {
        std::list<DataPoint::FileInfo>::iterator f = 
             files.insert(files.end(),DataPoint::FileInfo(rcf->get_name()));
odlog(DEBUG)<<"list_files_rc: lfn: "<<f->name<<std::endl;
        if(resolve) {
          is_resolved=false;  // hack !!!
          meta_size_valid=false; meta_checksum_valid=false;
          meta_created_valid=false; meta_validtill_valid=false;
          meta_lfn=f->name;
          if(!get_info(*f)) result=false;
          is_resolved=false;
          meta_size_valid=false; meta_checksum_valid=false;
          meta_created_valid=false; meta_validtill_valid=false;
        };
      };
      meta_lfn=tmp_rc_lfn;
      return result;
    } else {
      bool result = false;
      for(std::list<RCFile>::iterator rcf=rcfiles.begin();rcf!=rcfiles.end();++rcf) {
        if(meta_lfn == rcf->get_name()) {
          std::list<DataPoint::FileInfo>::iterator f = 
               files.insert(files.end(),DataPoint::FileInfo(meta_lfn.c_str()));
          result=true;
          if(resolve) {
            is_resolved=false;  // hack !!!
            meta_size_valid=false; meta_checksum_valid=false;
            meta_created_valid=false; meta_validtill_valid=false;
            if(!get_info(*f)) result=false;
          };
        };
      };
      return result;
    };
#else
    return false;
#endif
}

