#include "../std.h"

#include "../misc/guid.h"
#include "../misc/log_time.h"
#include "../misc/url_options.h"
#include <arc/url.h>
/*
#include "../config/config_map.h"
#include "../transfer/rls.h"
#include "../misc/checksum.h"
#include "../misc/stringtoint.h"
#include "../misc/inttostring.h"
#include "../misc/time_utils.h"
*/

#include "datapoint.h"

#ifdef HAVE_LFC_API_H
extern "C" {
#include <lfc_api.h>
#include <serrno.h>
}
#endif

DataPointLFC::DataPointLFC(const char* u):DataPointMeta(u) {
  if(u == NULL) return;
  if(strncasecmp("lfc://",u,6)) return;
  if(!process_meta_url()) return;
  if(locations.size()) location=locations.begin();
  is_valid=true;
}

DataPoint* DataPointLFC::CreateInstance(const char* u) {
  if(u == NULL) return NULL;
  if(strncasecmp("lfc://",u,6)) return NULL;
  return new DataPointLFC(u);
}

DataPointLFC::~DataPointLFC(void) {
}

/* perform resolve operation, which can take long time */
bool DataPointLFC::meta_resolve(bool source) {
#ifdef HAVE_LFC_API_H
  is_resolved=false;
  is_metaexisting=false;
  if(source) {
    if(meta_lfn.length() == 0) {
      odlog(INFO)<<"Source must contain LFN"<<std::endl;
      return false;
    };
  } else {
    if(meta_lfn.length() == 0) {
      odlog(INFO)<<"Destination must contain LFN"<<std::endl;
      return false;
    };
    if(locations.size() == 0) {
      odlog(INFO)<<"Locations are missing in destination LFC URL"<<std::endl;
      return false;
    };
  };
  if(lfc_startsess((char*)(meta_service_url.c_str()+6),"ARC") != 0) return false;
  int nbentries = 0;
  struct lfc_filereplica* entries = NULL;
  if(lfc_getreplica(meta_lfn.c_str(),NULL,NULL,&nbentries,&entries) != 0) {
    if(source || ((serrno != ENOENT) && (serrno != ENOTDIR))) {
      lfc_endsess();
      return false;
    };
    nbentries=0; entries=NULL;
  } else {
    is_metaexisting=true;
  };
  if(locations.size() == 0) {
    for(int n=0;n<nbentries;n++) {
      std::list<DataPointRLS::Location>::iterator loc =
           locations.insert(locations.end(),
                DataPointRLS::Location(meta_service_url,entries[n].sfn));
      loc->arg=(void*)1; // marker
      odlog(DEBUG)<<"Adding location: "<<meta_service_url<<" - "<<entries[n].sfn<<std::endl;
    };
  } else {
    std::list<Location>::iterator loc = locations.begin();
    for(;loc!=locations.end();++loc) {
      if(loc->arg != NULL) continue;
      for(int n=0;n<nbentries;n++) {
        if(strncmp(entries[n].sfn,loc->meta.c_str(),loc->meta.length())==0){
          odlog(DEBUG)<<"Adding location: "<<meta_service_url<<" - "<<entries[n].sfn<<std::endl;
          if(source) {
            loc->meta=meta_service_url; loc->url=entries[n].sfn;
          } else {
            loc->meta=meta_service_url;
          };
          loc->arg=(void*)1; break;
        };
      };
    };
  };
  if(entries) free(entries);
  struct lfc_filestatg st;
  if(lfc_statg(meta_lfn.c_str(),NULL,&st) == 0) {
    is_metaexisting=true;
    meta_size(st.filesize);
    meta_created(st.mtime);
    if(st.csumtype[0] && st.csumvalue[0]) {
      std::string csum = st.csumtype; csum+=":"; csum+=st.csumvalue;
      meta_checksum(csum.c_str());
    };
    guid=st.guid;
  };
  lfc_endsess();
  if(!source) {
    if(locations.size() == 0) {
      odlog(INFO)<<"No locations found for destination"<<std::endl;
      return false;
    };
    // Make pfns
    std::list<Location>::iterator loc = locations.begin();
    for(;loc!=locations.end();) {
      if(loc->arg != NULL) { loc=locations.erase(loc); continue; };
      if(strncasecmp(loc->url.c_str(),"se://",5) == 0) { loc->url+="?"; }
      else { loc->url+="/"; };
      loc->url+=meta_lfn;
      odlog(DEBUG)<<"Using location: "<<loc->meta<<" - "<<loc->url<<std::endl;
      ++loc;
    };
  };
  odlog(DEBUG)<<"meta_get_data: checksum: "<<meta_checksum()<<std::endl;
  odlog(DEBUG)<<"meta_get_data: size: "<<meta_size()<<std::endl;
  odlog(DEBUG)<<"meta_get_data: created: "<<meta_created()<<std::endl;
  if(common_url_options.length() != 0) {
    std::list<Location>::iterator loc = locations.begin();
    for(;loc!=locations.end();++loc) {
      add_url_options(loc->url,common_url_options.c_str(),0);
    };
  };
  location=locations.begin();
  is_resolved=true;
  return true;
#else
  return false;
#endif
}

bool DataPointLFC::meta_preregister(bool replication,bool force) {
#ifdef HAVE_LFC_API_H
  if(replication) { /* replicating inside same lfn */
    if(!is_metaexisting) { /* for replication it must be there */
      odlog(ERROR)<<"LFN is missing in LFC (needed for replication)"<<std::endl;
      return false;
    };
    return true;
  };
  if(is_metaexisting) { /* algorithm require this to be new file */
    if(!force) {
      odlog(ERROR)<<"LFN already exists in LFC"<<std::endl;
      return false;
    };
    return true;
  };
  if(lfc_startsess((char*)(meta_service_url.c_str()+6),"ARC") != 0) return false;
  GUID(guid);
  if(lfc_creatg(meta_lfn.c_str(),guid.c_str(),
                    S_IRUSR | S_IWUSR | S_IRGRP | S_IWGRP) != 0) {
    lfc_endsess();
    return false;
  };
  if(meta_checksum_valid) {
    std::string ckstype;
    std::string cksumvalue = meta_checksum();
    std::string::size_type p = cksumvalue.find(':');
    if(p == std::string::npos) {
      ckstype="cksum";
    } else {
      ckstype=cksumvalue.substr(0,p);
      cksumvalue=cksumvalue.substr(p+1);
    };
    if(meta_size_valid) {
      lfc_setfsizeg(guid.c_str(),meta_size(),ckstype.c_str(),(char*)(cksumvalue.c_str()));
     } else {
      lfc_setfsizeg(guid.c_str(),meta_size(),NULL,NULL);
     };
  } else if(meta_size_valid) {
    lfc_setfsizeg(guid.c_str(),meta_size(),NULL,NULL);
  };
  //if((meta_created_valid) {
  //};
  lfc_endsess();
  return true;
#else
  return false;
#endif
}

bool DataPointLFC::meta_postregister(bool replication,bool failure) {
#ifdef HAVE_LFC_API_H
  if(guid.empty()) {
    odlog(ERROR)<<"No GUID defined for LFN - probably not preregistered"<<std::endl;
    return false;
  };
  std::string pfn(location->url.c_str());
  ::canonic_url(pfn); // it is always better to register pure url
  std::string server;
  {
    URL u(location->url);
    server=u.Host();
  };
  if(lfc_startsess((char*)(meta_service_url.c_str()+6),"ARC") != 0) return false;
  if(lfc_addreplica(guid.c_str(),NULL,server.c_str(),pfn.c_str(),'-','P',NULL,NULL) != 0) {
    lfc_endsess();
    return false;
  };
  if(meta_checksum_valid) {
    std::string ckstype;
    std::string cksumvalue = meta_checksum();
    std::string::size_type p = cksumvalue.find(':');
    if(p == std::string::npos) {
      ckstype="cksum";
    } else {
      ckstype=cksumvalue.substr(0,p);
      cksumvalue=cksumvalue.substr(p+1);
    };
    if(meta_size_valid) {
      lfc_setfsizeg(guid.c_str(),meta_size(),ckstype.c_str(),(char*)(cksumvalue.c_str()));
     } else {
      lfc_setfsizeg(guid.c_str(),meta_size(),NULL,NULL);
     };
  } else if(meta_size_valid) {
    lfc_setfsizeg(guid.c_str(),meta_size(),NULL,NULL);
  };
  //if((meta_created_valid) {
  //};
  lfc_endsess();
  return true;
#else
  return false;
#endif
}

bool DataPointLFC::meta_preunregister(bool replication) {
#ifdef HAVE_LFC_API_H
  if(replication) return true;
  if(lfc_startsess((char*)(meta_service_url.c_str()+6),"ARC") != 0) return false;
  if(lfc_unlink(meta_lfn.c_str()) != 0) {
    if((serrno != ENOENT) && (serrno != ENOTDIR)) {
      odlog(ERROR)<<"Failed to remove LFN in LFC - You may need to do that by hand"<<std::endl;
      lfc_endsess();
      return false;
    };
  };
  lfc_endsess();
  return true;
#else
  return false;
#endif
}

bool DataPointLFC::meta_unregister(bool all) {
#ifdef HAVE_LFC_API_H
  if(!all) {
    if(location == locations.end()) { 
      odlog(ERROR)<<"Location is missing"<<std::endl;
      return false;
    };
    if(strncasecmp(location->url.c_str(),"se://",5) == 0) {
      odlog(DEBUG)<<"SE location will be unregistered automatically"<<std::endl;
      return true;
    };
  };
  if(lfc_startsess((char*)(meta_service_url.c_str()+6),"ARC") != 0) return false;
  if(all) {
    int nbentries = 0;
    struct lfc_filereplica* entries = NULL;
    if(lfc_getreplica(meta_lfn.c_str(),NULL,NULL,&nbentries,&entries) != 0) {
      lfc_endsess();
      if((serrno == ENOENT) || (serrno == ENOTDIR)) return true;
      return false;
    };
    for(int n=0;n<nbentries;n++) {
      if(lfc_delreplica(guid.c_str(),NULL,entries[n].sfn) != 0) {
        if(serrno == ENOENT) continue;
        lfc_endsess();
        odlog(ERROR)<<"Failed to remove location from LFC"<<std::endl;
        return false;
      };
    };
    if(lfc_unlink(meta_lfn.c_str()) != 0) {
      if((serrno != ENOENT) && (serrno != ENOTDIR)) {
        odlog(ERROR)<<"Failed to remove LFN in LFC"<<std::endl;
        lfc_endsess();
        return false;
      };
    };
  } else {
    if(lfc_delreplica(guid.c_str(),NULL,location->url.c_str()) != 0) {
      lfc_endsess();
      odlog(ERROR)<<"Failed to remove location from LFC"<<std::endl;
      return false;
    };
  };
  lfc_endsess();
  return true;
#else
  return false;
#endif
}

/* lfc://[url[|url[...]]@]server/lfn */
bool DataPointLFC::process_meta_url(void) {
  if(!strncasecmp(url.c_str(),"lfc://",6)) {
    meta_service_url.resize(0); locations.clear(); meta_lfn.resize(0);
    std::string url_(url.c_str());
    /* find out if it contains locations */
    std::string::size_type loc_start=6;
    std::string::size_type loc_end=url_.find('@',loc_start);
    std::string urls("");
    if(loc_end!=std::string::npos) {
      urls=url_.substr(loc_start,loc_end-loc_start);
      url_.erase(loc_start,loc_end-loc_start+1);
    };
    /* get lfn */
    std::string::size_type server_start=6;
    std::string::size_type server_end=url_.find('/',server_start);
    std::string meta_lfn;
    if(server_end==std::string::npos) {
      meta_lfn=""; meta_service_url=url_;
    } else {
      meta_lfn=url_.substr(server_end+1);
      meta_service_url=url_.substr(0,server_end);
    };
    std::string guid_val;
//    if(get_url_option(meta_service_url,"guid",guid_val) == 0) {
//      if((guid_val == "yes") || (guid_val == "")) {
//        guid_enabled=true;
//      };
//    };
    ::canonic_url(meta_service_url);
    extract_meta_attributes(meta_lfn);
    meta_lfn=meta_lfn;
    odlog(DEBUG)<<"LFN: "<<meta_lfn<<std::endl;
    odlog(DEBUG)<<"LFC server: "<<meta_service_url<<std::endl;
    odlog(DEBUG)<<"Location urls: "<<urls<<std::endl;
    std::string::size_type n=0;
    for(std::string::size_type nn=0;n<urls.length();) {
      nn=urls.find('|',n); if(nn == std::string::npos) nn=urls.length();
      if(n == nn) { n++; continue; };
      std::string loc(urls.c_str()+n,nn-n);
      if(loc[0] == ';') { common_url_options+=loc; }
      else {
        locations.push_back(DataPointRLS::Location(loc.c_str(),loc.c_str()));
      };
      n=nn+1;
    };
    return true;
  };
  return false;
};

bool DataPointLFC::list_files(std::list<DataPoint::FileInfo> &files,bool resolve) {
#ifdef HAVE_LFC_API_H
  if(lfc_startsess((char*)(meta_service_url.c_str()+6),"ARC") != 0) return false;
  struct lfc_filestatg st;
  if(lfc_statg(meta_lfn.c_str(),NULL,&st) != 0) { 
    lfc_endsess();
    return false;
  };
  std::list<DataPoint::FileInfo>::iterator f = files.insert(files.end(),FileInfo(meta_lfn.c_str()));
  f->size=st.filesize; f->size_available=true;
  if(st.csumvalue[0]) {
    f->checksum=st.csumtype; f->checksum+=":"; f->checksum+=st.csumvalue;
    f->checksum_available=true;
  };
  f->created=st.mtime; f->created_available=true;
  f->type=(st.filemode & S_IFDIR)?DataPoint::FileInfo::file_type_dir:DataPoint::FileInfo::file_type_file;
  int nbentries = 0;
  struct lfc_filereplica* entries = NULL;
  if(lfc_getreplica(meta_lfn.c_str(),NULL,NULL,&nbentries,&entries) == 0) {
    for(int n=0;n<nbentries;n++) {
      f->urls.push_back(std::string(entries[n].sfn));
    };
  };
  return true;
#else
  return false;
#endif
}


