#ifndef __DATAMOVEPAR_H__
#define __DATAMOVEPAR_H__

#include "../std.h"

#include <string>

#include "../misc/condition.h"
#include "../transfer/url_map.h"

#include "datamove.h"

/// Wrapper around DataMove class to handle few transfers at once.
class DataMovePar : public DataMove {
 private:
  unsigned long long int min_speed;
  time_t min_speed_time;
  unsigned long long int min_average_speed;
  time_t max_inactivity_time;
  class DataPointPair {
   public:
    DataPointPair* next;
    DataPointPair* prev;
    DataPoint source;
    DataPoint destination;
    result res;
    bool transfer;
    bool transfered;
    bool no_cache;
    DataPointPair(const char* source_url,const char* destination_url):
                source(source_url),destination(destination_url),
                res(undefined_error),next(NULL),prev(NULL),
                transfer(false),transfered(false),no_cache(false)
    { };
    ~DataPointPair(void) { };
  };
  DataPointPair* points_first;
  DataPointPair* points_last;
  CondSimple transfer_cond;
  static void transfer_callback(DataMovePar* it,result res,const char* failure_description,void* arg);
 public:
  /// Constructor
  DataMovePar(void);
  /// Destructor. Object can't be destoryed while there is any 
  /// transfer in progress.
  ~DataMovePar(void);
  /// Add one more source and destination pair to list of handled transfers.
  /// \param source_url URL (or meta-URL) of source file
  /// \param destination_url URL (or meta-URL) of destination file
  bool Add(const char* source_url,const char* destination_url);
  /// Get source and destination pair from list with result of transfer
  /// \param source_url on exit contains URL (or meta-URL) of source file
  /// \param destination_url on exit contains URL (or meta-URL) of destination file
  /// \param res result of operation
  bool Get(std::string &source_url,std::string &destination_url,result &res);
  /// Perform transfer
  /// \param num number of simultaneous transfers
  bool Transfer(int num = 5);
  /// Perform transfer
  /// \param cache to control data caching (use default constructor for no caching)
  /// \param map to change/map source URLs (use default constructor for no maping)
  /// \param num number of simultaneous transfers
  bool Transfer(DataCache cache,const UrlMap &map,int num = 5);
};

#endif

