#include "../std.h"

#include "../misc/log_time.h"

#include "datamovepar.h"

DataMovePar::DataMovePar(void) {
  points_first=NULL; points_last=NULL;
  retry(false);
}

DataMovePar::~DataMovePar(void) {
  DataPointPair* cur = points_first;
  for(;cur!=NULL;) {
    DataPointPair* tmp = cur->next;
    delete cur;
    cur=tmp;
  };
}

bool DataMovePar::Add(const char* source_url,const char* destination_url) {
  odlog(ERROR)<<"DataMovePar::Add : source "<<source_url<<std::endl;
  odlog(ERROR)<<"DataMovePar::Add : destination "<<destination_url<<std::endl;
  DataPointPair* point = new DataPointPair(source_url,destination_url);
  if(points_last) {
    points_last->next=point;
    point->prev=points_last;
    points_last=point;
  }
  else {
    points_first=point;
    points_last=point;
  };
  return true;
}

bool DataMovePar::Get(std::string &source_url,std::string &destination_url,result &res) {
  if(points_first==NULL) return false;
  source_url=points_first->source.base_url();
  destination_url=points_first->destination.base_url();
  res=points_first->res;
  DataPointPair* tmp = points_first;
  if(points_first->next) { points_first->next->prev=NULL; }
  else { points_last=NULL; };
  points_first=points_first->next;
  delete tmp;
  return true;
}

void DataMovePar::transfer_callback(DataMovePar* it,result res,const char* failure_reason,void* arg) {
  DataPointPair** curp=(DataPointPair**)arg;
  it->transfer_cond.block();
  DataPointPair* cur = *curp;
  if(res==success) {
    odlog(ERROR)<<"DataMovePar::transfer_callback: success"<<std::endl;
    cur->res=res; cur->transfered=true; cur->transfer=false;
    (*curp)=NULL;
    it->transfer_cond.signal_nonblock();
    it->transfer_cond.unblock();
    return;
  };
  if(res == cache_error) {
    odlog(ERROR)<<"DataMovePar::transfer_callback: cache failure"<<std::endl;
    cur->res=res;
    if(cur->no_cache) cur->transfered=true; /* shouldn't happen */ 
    cur->no_cache=true;  /* give it one more chance without cache */ 
    cur->transfer=false;
    (*curp)=NULL;
    it->transfer_cond.signal_nonblock();
    it->transfer_cond.unblock();
    return;
  };
  if(res == credentials_expired_error) {
    odlog(ERROR)<<"DataMovePar::transfer_callback: credentials expired"<<std::endl;
    cur->res=res;
    cur->transfered=true; /* iteration is useless */
    cur->transfer=false;
    (*curp)=NULL;
    it->transfer_cond.signal_nonblock();
    it->transfer_cond.unblock();
    return;
  };
  if((res == read_acquire_error) || (res == write_acquire_error)) {
    odlog(ERROR)<<"DataMovePar::transfer_callback: bad URL"<<std::endl;
    cur->res=res;
    cur->transfered=true; /* iteration is useless */
    cur->transfer=false;
    (*curp)=NULL;
    it->transfer_cond.signal_nonblock();
    it->transfer_cond.unblock();
    return;
  };
  odlog(ERROR)<<"DataMovePar::transfer_callback: failure"<<std::endl;
  cur->res=res;
  if((!cur->source.have_location()) || (!cur->destination.have_location())) {
    odlog(ERROR)<<"DataMovePar::transfer_callback: out of tries"<<std::endl;
    cur->transfered=true; /* can't iterate anymore */ 
  };
  cur->transfer=false;
  (*curp)=NULL;
  it->transfer_cond.signal_nonblock();
  it->transfer_cond.unblock();
  return;
}

bool DataMovePar::Transfer(int num) {
  return DataMovePar::Transfer(DataCache(),UrlMap(),num);
}

bool DataMovePar::Transfer(DataCache cache,const UrlMap &map,int num) {
  if(points_first == NULL) return true;
 
  DataPointPair** handlers=(DataPointPair**)malloc(sizeof(DataPointPair*)*num);
  if(handlers == NULL) return false; 
  for(int n=0;n<num;n++) handlers[n]=NULL;
  verbose(true);
  DataPointPair* cur = NULL;
  DataCache invalid_cache;
  for(;;) {
    if(cur == NULL) cur=points_first;
    transfer_cond.block();
    /* check for empty slots */
    int n = 0;
    for(;n<num;n++) if(handlers[n]==NULL) break;
    /* check for current status of transfers over all requested */
    bool have_transfer = false;
    DataPointPair* cur_ = NULL;
    bool cur_passed = false;
    for(DataPointPair* p=points_first;p!=NULL;p=p->next) {
      if(p == cur) cur_passed=true;
      if(p->transfer) { have_transfer=true; continue; };
      if(p->transfered) continue;
      if(p == cur) { cur_=p; cur_passed=false; continue; };
      if(cur_passed) { cur_=p; cur_passed=false; }
      else { if(cur_ == NULL) { cur_=p; }; };
    };
    cur=cur_;
    transfer_cond.unblock();
    /* have snapshot - make decision */
    if((cur != NULL) && (n<num)) { /* can and want to transfer */
      handlers[n]=cur;
      odlog(ERROR)<<"Transfer: source: "<<cur->source<<std::endl;
      odlog(ERROR)<<"Transfer: destination: "<<cur->destination<<std::endl;
      if(verbose()) {
        std::string s = cur->source.base_url();
        std::string d = cur->destination.base_url();
        std::string::size_type n;
        if((n=s.rfind('/')) != std::string::npos) { s.erase(0,n+1); };
        if((n=d.rfind('/')) != std::string::npos) { d.erase(0,n+1); };
        if(s == d) {
          verbose(s+" ");
        } else {
          verbose(s+"->"+d+" ");
        };
      }
      cur->transfer=true;
      result r;
      std::string failure_reason;
      if(cur->no_cache) {
        r=DataMove::Transfer(cur->source,cur->destination,invalid_cache,map,
                     &failure_reason,(callback)&transfer_callback,handlers+n);
      } else {
        r=DataMove::Transfer(cur->source,cur->destination,cache,map,
                     &failure_reason,(callback)&transfer_callback,handlers+n);
      };
      if(r != success) {  /* imitate callback with error */
        transfer_callback(this,r,failure_reason.c_str(),handlers+n);
      };
/*
      else { cur->transfer=true; };
*/
      cur=cur->next;
      continue;
    };
    if(((n<num) && have_transfer) || (n>=num)) {
      /* have slots but have nothing to transfer or out of slots - wait*/
      transfer_cond.wait();
      continue;
    };
    /* nothing to transfer and nothing is transfering - quit */
    break;
  };
  free(handlers);
  return true;
}

