#include "../std.h"
#include <string>
#include <list>
#include <iostream>

//#include "../misc/condition.h"
//#include "../misc/checksum.h"
//#include "../misc/inttostring.h"
#include "../https/SRM/srm1_soapH.h"
extern SOAP_NMAC struct Namespace srm1_soap_namespaces[];
#include "../https/SRM/srm_url.h"
#include "../https/SRM/srm_client.h"
#include "../misc/random.h"
#include "../misc/url_options.h"
#include "../misc/log_time.h"
#include "databufferpar.h"
#include "datapoint.h"
#include "datahandle_srm.h"

DataHandle* DataHandleSRM::CreateInstance(DataPoint* url_) {
  if((!url_) || (!*url_)) return NULL;
  const char* cur_url = url_->current_location();
  if(strncasecmp("srm://",cur_url,6)) return NULL;
  return new DataHandleSRM(url_);
}

DataHandleSRM::DataHandleSRM(DataPoint* url_):DataHandleCommon(url_) {
  r_handle=NULL; r_url=NULL;
  srm_request=NULL;
}

DataHandleSRM::~DataHandleSRM(void) {
  stop_reading();
  stop_writing();
  deinit_handle();
}

bool DataHandleSRM::init_handle(void) {
  if(!DataHandleCommon::init_handle()) return false;
  const char* cur_url = url->current_location();
  if(!strncasecmp("srm://",cur_url,6)) return true;
  return false;
}

bool DataHandleSRM::deinit_handle(void) {
  if(!DataHandleCommon::deinit_handle()) return false;
  if(r_handle) {
    //r_handle->stop_reading(); // just in case
    //r_handle->stop_writing(); // just in case
    //r_handle->deinit_handle();
    delete r_handle; r_handle=NULL;
  };
  if(r_url) { delete r_url; r_url=NULL; };
  return true;
}

bool DataHandleSRM::analyze(analyze_t &arg) {
  return DataHandleCommon::analyze(arg);
}

bool DataHandleSRM::start_reading(DataBufferPar &buf) {
#ifndef SRM_MISSING
  if(r_handle) return false; // must be operation in progress
  if(!DataHandleCommon::start_reading(buf)) return false;
  SRM_URL srm_url(url->current_location());
  if(!srm_url) {
    DataHandleCommon::stop_reading();
    return false;
  };
  SRMClient client(srm_url);
  if(!client) {
    DataHandleCommon::stop_reading();
    return false;
  };
  r_url=NULL; r_handle=NULL; srm_request=NULL;
  std::list<std::string> turls;
  if(!no_checks) {
    odlog(DEBUG)<<"start_reading_srm: looking for metadata: "<<c_url.c_str()<<std::endl;
    unsigned long long int size;
    std::string checksum;
    if(!client.info(srm_url.FileName().c_str(),srm_url,size,checksum)) {
      DataHandleCommon::stop_reading();
      return false;
    };
    /* provide some metadata */
    odlog(INFO)<<"start_reading_srm: obtained size: "<<size<<std::endl;
    if(size > 0) url->meta_size(size);
    odlog(INFO)<<"start_reading_srm: obtained checksum: "<<checksum<<std::endl;
    if(checksum.length() > 0) url->meta_checksum(checksum.c_str());
  };
  srm_request = new SRMClientRequest(); if(!srm_request) goto error_exit;
  if(!client.getTURLs(*srm_request,srm_url.FileName().c_str(),srm_url,turls)) {
    goto error_exit;
  };
  client.disconnect();
  // Choose handled URL randomly
  for(;;) {
    if(turls.size() <= 0) break;
    int n = Random::get(turls.size()-1);
    std::list<std::string>::iterator i = turls.begin(); for(;n;++i,++n) { };
    if(i == turls.end()) continue;
    // Avoid redirection to SRM
    odlog(DEBUG)<<"Checking URL returned by SRM: "<<*i<<std::endl;
    if(strncasecmp(i->c_str(),"srm://",6) == 0) { turls.erase(i); continue; };
    // Try to use this TURL + old options
    {
      std::string options;
      get_url_options(url->current_location(),options);
      if(options.length()) add_url_options(*i,options.c_str(),0);
    };
    r_url = DataPoint::CreateInstance(i->c_str());
    // check if url can be handled
    if(!r_url) { turls.erase(i); continue; };
    if(r_url->meta()) { delete r_url; r_url=NULL; turls.erase(i); continue; };
    break;
  };
  if(r_url == NULL) {
    odlog(INFO)<<"SRM returned no useful Transfer URLs: "<<c_url<<std::endl;
    goto error_exit;
  };
  r_handle = new DataHandle(r_url);
  r_handle->additional_checks(additional_checks());
  r_handle->secure(force_secure);
  r_handle->passive(force_passive);
  //r_handle->transfer_streams=transfer_streams;
  //r_handle->cacheable=cacheable;
  //r_handle->linkable=linkable;
  odlog(INFO)<<"Redirecting to new URL: "<<*r_url<<std::endl;
  if(!(r_handle->start_reading(buf))) goto error_exit;
  return true;
error_exit:
  if(r_handle) delete r_handle; r_handle=NULL;
  if(r_url) delete r_url; r_url=NULL;
  if(srm_request) delete srm_request; srm_request=NULL;
  DataHandleCommon::stop_reading();
#endif
  return false;
}

bool DataHandleSRM::stop_reading(void) {
#ifndef SRM_MISSING
  if(!r_handle) return true;
  if(!DataHandleCommon::stop_reading()) return false;
  bool r = r_handle->stop_reading();
  delete r_handle;
  if(r_url) delete r_url;
  if(srm_request) {
    SRM_URL srm_url(url->current_location());
    if(srm_url) {
      SRMClient client(srm_url);
      if(client) {
        client.release(*srm_request,srm_url.FileName().c_str(),srm_url);
      };
    };
    delete srm_request;
  };
  r_handle=NULL; r_url=NULL; srm_request=NULL;
  return r;
#else
  return false;
#endif
}

bool DataHandleSRM::start_writing(DataBufferPar &buf,DataCallback *space_cb) {
#ifndef SRM_MISSING
  if(r_handle) return false; // must be operation in progress
  if(!DataHandleCommon::start_writing(buf)) return false;
  SRM_URL srm_url(url->current_location());
  if(!srm_url) {
    DataHandleCommon::stop_writing();
    return false;
  };
  SRMClient client(srm_url);
  if(!client) {
    DataHandleCommon::stop_writing();
    return false;
  };
  r_url=NULL; r_handle=NULL; srm_request=NULL;
  std::list<std::string> turls;
  srm_request = new SRMClientRequest(); if(!srm_request) goto error_exit;
  if(!client.putTURLs(*srm_request,srm_url.FileName().c_str(),srm_url,turls,url->meta_size())) goto error_exit;
  client.disconnect();
  // Choose handled URL randomly
  for(;;) {
    if(turls.size() <= 0) break;
    int n = Random::get(turls.size()-1);
    std::list<std::string>::iterator i = turls.begin(); for(;n;++i,++n) { };
    if(i == turls.end()) continue;
    odlog(DEBUG)<<"Checking URL returned by SRM: "<<*i<<std::endl;
    // Avoid redirection to SRM
    if(strncasecmp(i->c_str(),"srm://",6) == 0) { turls.erase(i); continue; };
    // Try to use this TURL + old options
    {
      std::string options;
      get_url_options(url->current_location(),options);
      if(options.length()) add_url_options(*i,options.c_str(),0);
    };
    r_url = DataPoint::CreateInstance(i->c_str());
    // check if url can be handled
    if(!r_url) { turls.erase(i); continue; };
    if(r_url->meta()) { delete r_url; r_url=NULL; turls.erase(i); continue; };
    break;
  };
  if(r_url == NULL) {
    odlog(INFO)<<"SRM returned no useful Transfer URLs: "<<c_url<<std::endl;
    goto error_exit;
  };
  r_handle = new DataHandle(r_url);
  //r_handle->ftp_threads=ftp_threads;
  //r_handle->cacheable=cacheable;
  //r_handle->linkable=linkable;
  //r_handle->force_secure=force_secure;
  //r_handle->force_passive=force_passive;
  odlog(INFO)<<"Redirecting to new URL: "<<*r_url<<std::endl;
  if(!(r_handle->start_writing(buf))) goto error_exit;
  return true;
error_exit:
  if(r_handle) delete r_handle; r_handle=NULL;
  if(r_url) delete r_url; r_url=NULL;
  if(srm_request) delete srm_request; srm_request=NULL;
  DataHandleCommon::stop_writing();
#endif
  return false;
}

bool DataHandleSRM::stop_writing(void) {
#ifndef SRM_MISSING
  if(!r_handle) return true;
  if(!DataHandleCommon::stop_writing()) return false;
  bool r = r_handle->stop_reading();
  delete r_handle;
  if(r_url) delete r_url;
  if(srm_request) {
    SRM_URL srm_url(url->current_location());
    if(srm_url) {
      SRMClient client(srm_url);
      if(client) {
        client.release(*srm_request,srm_url.FileName().c_str(),srm_url);
      };
    };
    delete srm_request;
  };
  r_handle=NULL; r_url=NULL; srm_request=NULL;
  return r;
#else
  return false;
#endif
}

bool DataHandleSRM::remove(void) {
#ifndef SRM_MISSING
  if(!DataHandleCommon::remove()) return false;
  SRM_URL srm_url(url->current_location());
  if(!srm_url) return false;
  SRMClient client(srm_url);
  if(!client) return false;
  odlog(DEBUG)<<"remove_srm: deleting: "<<c_url.c_str()<<std::endl;
  if(!client.remove(srm_url.FileName().c_str(),srm_url)) return false;
  return true;
#else
  return false;
#endif
}

bool DataHandleSRM::list_files(std::list<DataPoint::FileInfo> &files,bool resolve) {
#ifndef SRM_MISSING
  if(!DataHandleCommon::list_files(files,resolve)) return false;
  SRM_URL srm_url(url->current_location());
  if(!srm_url) return false;
  SRMClient client(srm_url);
  if(!client) return false;
  odlog(DEBUG)<<"list_files_srm: looking for metadata: "<<c_url.c_str()<<std::endl;
  unsigned long long int size;
  std::string checksum;
  if(!client.info(srm_url.FileName().c_str(),srm_url,size,checksum)) return false;
  if(size > 0) url->meta_size(size);
  if(checksum.length() > 0) url->meta_checksum(checksum.c_str());
  std::list<DataPoint::FileInfo>::iterator f =
     files.insert(files.end(),DataPoint::FileInfo(srm_url.FileName().c_str()));
  f->type=DataPoint::FileInfo::file_type_file;
  if(url->meta_size_available()) {
    f->size=url->meta_size();
    f->size_available=true;
  };
  if(url->meta_created_available()) {
    f->created=url->meta_created();
    f->created_available=true;
  };
  return true;
#else
  return false;
#endif
}

bool DataHandleSRM::check(void) {
#ifndef SRM_MISSING
  if(!DataHandleCommon::check()) return false;
  SRM_URL srm_url(url->current_location());
  if(!srm_url) return false;
  SRMClient client(srm_url);
  if(!client) return false;
  odlog(DEBUG)<<"check_srm: looking for metadata: "<<c_url.c_str()<<std::endl;
  unsigned long long int size;
  std::string checksum;
  if(!client.info(srm_url.FileName().c_str(),srm_url,size,checksum)) return false;
  odlog(INFO)<<"check_srm: obtained size: "<<size<<std::endl;
  if(size > 0) url->meta_size(size);
  odlog(INFO)<<"check_srm: obtained checksum: "<<checksum<<std::endl;
  if(checksum.length() > 0) url->meta_checksum(checksum.c_str());
  return true;
#else
  return false;
#endif
}

