#ifndef __DATAHANDLE_HTTPG_H__
#define __DATAHANDLE_HTTPG_H__

#include "../std.h"

#include <string>
#include <list>

#include "../misc/condition.h"
#include "../misc/globus_modules.h"

#include "datahandle.h"

class httpg_info_t;

class DataHandleHTTPg: public DataHandleCommon {
 private:
  httpg_info_t* httpg_stat;
 protected:
  virtual bool init_handle(void); 
  virtual bool deinit_handle(void); 
 public:
  static DataHandle* CreateInstance(DataPoint* url_);
  DataHandleHTTPg(DataPoint* url_);
  virtual ~DataHandleHTTPg(void);
  virtual bool start_reading(DataBufferPar &buffer);
  virtual bool start_writing(DataBufferPar &buffer,DataCallback *space_cb = NULL);
  virtual bool stop_reading(void);
  virtual bool stop_writing(void);
  virtual bool analyze(analyze_t &arg);
  virtual bool check(void);
  virtual bool remove(void);
  virtual bool list_files(std::list<DataPoint::FileInfo> &files,bool resolve = true);
  virtual bool out_of_order(void);
};

#endif
