#ifndef __DATAHANDLE_FILE_H__
#define __DATAHANDLE_FILE_H__

#include "../std.h"

#include <string>
#include <list>

#include <globus_common.h>
#include <globus_ftp_client.h>
#include <globus_ftp_client_plugin.h>

#include "../misc/condition.h"
#include "../misc/globus_modules.h"

#include "datahandle.h"

class DataHandleFile: public DataHandleCommon {
 private:
  int fd;
  pthread_t file_thread;
  pthread_attr_t file_thread_attr;
  bool start_reading_file(DataBufferPar &buffer);
  bool start_writing_file(DataBufferPar &buffer,DataCallback *space_cb);
  bool stop_reading_file(void);
  bool stop_writing_file(void);
  bool check_file(void);
  bool remove_file(void);
  static void* read_file(void* arg);
  static void* write_file(void* arg);
  CondSimple file_thread_exited;
  bool is_channel;
 protected:
  virtual bool init_handle(void);
  virtual bool deinit_handle(void);
 public:
  static DataHandle* CreateInstance(DataPoint* url_);
  DataHandleFile(DataPoint* url_);
  virtual ~DataHandleFile(void);
  virtual bool start_reading(DataBufferPar &buffer);
  virtual bool start_writing(DataBufferPar &buffer,DataCallback *space_cb = NULL);
  virtual bool stop_reading(void);
  virtual bool stop_writing(void);
  virtual bool analyze(analyze_t &arg);
  virtual bool check(void);
  virtual bool remove(void);
  virtual bool list_files(std::list<DataPoint::FileInfo> &files,bool resolve = true);
  virtual bool out_of_order(void);
};

#endif
