#include "../std.h"

#include <string>
#include <fstream>

#include "conf.h"
#include "environment.h"
#include "gridmap.h"
#include "../misc/stringtoint.h"
#include "../jobs/users.h"
#include "../misc/substitute.h"
#include "../misc/log_time.h"
#include "config_sections.h"
#include "config_map.h"


UrlMapConfig::UrlMapConfig(void) {
  std::ifstream cfile;
  ConfigSections* cf = NULL;
  if(nordugrid_config_loc.length() == 0) read_env_vars(true);
  if(!config_open(cfile)) {
    olog << "Can't open configuration file." << std::endl;
  };
  if(central_configuration) {
    cf=new ConfigSections(cfile);
    cf->AddSection("common");
    cf->AddSection("grid-manager");
  };
  for(;;) {
    std::string rest;
    std::string command;
    if(central_configuration) {
      cf->ReadNext(command,rest);
    } else {
      command = config_read_line(cfile,rest);
    };
    if(command.length() == 0) break;
    else if(command == "copyurl") {
      std::string initial = config_next_arg(rest);
      std::string replacement = config_next_arg(rest);
      if((initial.length() == 0) || (replacement.length() == 0)) {
        olog<<"Not enough parameters in copyurl"<<std::endl; continue;
      };
      add(initial,replacement);
    }
    else if(command == "linkurl") {
      std::string initial = config_next_arg(rest);
      std::string replacement = config_next_arg(rest);
      if((initial.length() == 0) || (replacement.length() == 0)) {
        olog<<"Not enough parameters in linkurl"<<std::endl; continue;
      };
      std::string access = config_next_arg(rest);
      if(access.length() == 0) access = replacement;
      add(initial,replacement,access);
    };
  };
  config_close(cfile);
  if(cf) delete cf;
}

UrlMapConfig::~UrlMapConfig(void) {
}

