#include "../std.h"

#include <string>
#include <list>
#include <vector>

#include "gacl_auth.h"

#ifdef HAVE_VOMS
#include <voms_api.h>
#endif

GACLuser* AuthUserGACL(AuthUser& auth) {
  GACLuser* user = NULL;
  GACLcred* cred = NULL;

  if((cred=GACLnewCred("person")) == NULL) goto err_exit;
  if(!GACLaddToCred(cred,"dn",(char*)(auth.DN()))) goto err_exit;
  /* GACLnewUser does not create copy of cred. But GACLfreeUser destoyrs cred */
  if((user=GACLnewUser(cred)) == NULL) goto err_exit;
  cred=NULL;
  if(auth.hostname() && auth.hostname()[0]) {
    if((cred=GACLnewCred("dns")) == NULL) goto err_exit;
    if(!GACLaddToCred(cred,"hostname",(char*)(auth.hostname()))) goto err_exit;
    if(!GACLuserAddCred(user,cred)) goto err_exit;
    cred=NULL;
  };
#ifdef HAVE_VOMS
  for(std::vector<struct voms>::const_iterator v = auth.voms().begin();v!=auth.voms().end();++v) {
    for(std::vector<struct data>::const_iterator u = v->std.begin();u!=v->std.end();++u) {
      if((cred=GACLnewCred("voms")) == NULL) goto err_exit;
      if(!GACLaddToCred(cred,"voms",(char*)(v->server.c_str()))) goto err_exit;
      if(!GACLaddToCred(cred,"vo",(char*)(v->voname.c_str()))) goto err_exit;
      if(!GACLaddToCred(cred,"group",(char*)(u->group.c_str()))) goto err_exit;
      if(!GACLaddToCred(cred,"role",(char*)(u->role.c_str()))) goto err_exit;
      if(!GACLaddToCred(cred,"capability",(char*)(u->cap.c_str()))) goto err_exit;
      if(!GACLuserAddCred(user,cred)) goto err_exit;
      cred=NULL;
    };
  };
#endif
  for(std::list<std::string>::const_iterator v = auth.VOs().begin();v!=auth.VOs().end();++v) {
    if((cred=GACLnewCred("vo")) == NULL) goto err_exit;
    if(!GACLaddToCred(cred,"name",(char*)(v->c_str()))) goto err_exit;
    if(!GACLuserAddCred(user,cred)) goto err_exit;
    cred=NULL;
  };
  return user;
err_exit:
  if(cred) GACLfreeCred(cred);
  if(user) GACLfreeUser(user);
  return NULL;
}

GACLperm AuthUserGACLTest(GACLacl* acl,AuthUser& auth) {
  if(acl == NULL) return GACL_PERM_NONE;
  GACLuser* user=AuthUserGACL(auth);
  if(user == NULL) return GACL_PERM_NONE;
  GACLperm perm=GACLtestUserAcl(acl,user);
  if(user) GACLfreeUser(user);
  return perm;
}
