#!/bin/bash

# Initializes/checks environment variables: SGE_ROOT, SGE_CELL, SGE_BIN_PATH

# Valued defines in arc.conf take priority over pre-existing environment
# variables. Also defines SGE_BIN_PATH (the location of SGE executables)
# Condor executables are located using the following cues:
# 1. sge_bin_path option in arc.conf
# 3. SGE_ROOT and SGE_ARCH environment variables
# 4. PATH environment variable

# Synopsis:
#
#   source config_parser.sh
#   config_parse_file /etc/arc.conf || exit 1
#   config_update_from_section "common"
#   source configure-sge-env.sh || exit 1


SGE_CELL=${SGE_CELL:-default}
SGE_CELL=${CONFIG_sge_cell:-$SGE_CELL}


SGE_ROOT=${CONFIG_sge_root:-$SGE_ROOT}

if [ -z "$SGE_ROOT" ]; then
    echo 'SGE_ROOT not set'
    return 1
fi

qsub=$(type -p qsub)
SGE_BIN_PATH=${qsub%/*}
unset qsub

if [ ! -z "$SGE_ARCH" ]; then
    SGE_BIN_PATH="$SGE_ROOT/bin/$SGE_ARCH"
fi

if [ ! -z "$CONFIG_lrms_bin_path" ]; then
    SGE_BIN_PATH=$CONFIG_lrms_bin_path;
fi

if [ ! -z "$CONFIG_sge_bin_path" ]; then
    SGE_BIN_PATH=$CONFIG_sge_bin_path;
fi

if [ ! -x "$SGE_BIN_PATH/qsub" ]; then
    echo 'SGE executables not found!'
    return 1
fi
export SGE_BIN_PATH SGE_ROOT SGE_CELL


