#!/bin/sh -f
#
# set environment variables:
#   LL_BIN_PATH
#
# Christian Soettrup <soettrup@nbi.dk>
#

##############################################################
# Reading configuration from $ARC_CONFIG
##############################################################


ARC_CONFIG=${ARC_CONFIG:-/etc/arc.conf}

if [ ! -r "$ARC_CONFIG" ]; then
  echo "ARC configuration file arc.conf was not found (usually /etc/arc.conf)"
  if [ -r "/etc/nordugrid.conf" ]; then
    echo "Fallback /etc/nordugrid.conf was found, trying to use that one"
    ARC_CONFIG="/etc/nordugrid.conf"
  else
    echo "Failed to find the fallback /etc/nordugrid.conf"
    exit 1
  fi  
fi


# Path to ll commands
LL_BIN_PATH=${LL_BIN_PATH:-`grep ^ll_bin_path $ARC_CONFIG | sed 's/^ll_bin_path\s*=*\s*\(\"*\)\(.*\)\1/\2/'`}
if [ ! -d ${LL_BIN_PATH} ] ; then
    echo "Could not set LL_BIN_PATH." 1>&2
    exit 1
fi

# Local scratch disk
RUNTIME_LOCAL_SCRATCH_DIR=${RUNTIME_LOCAL_SCRATCH_DIR:-`grep ^scratchdir $ARC_CONFIG | sed 's/^scratchdir\s*=*\s*\(\"*\)\(.*\)\1/\2/'`}
export RUNTIME_LOCAL_SCRATCH_DIR

