if ( -r /etc/sysconfig/globus ) then
  eval `cat /etc/sysconfig/globus | grep -v '^#' | grep = | sed 's/^/set /'` 
endif

if (! $?GLOBUS_LOCATION ) then
  set GLOBUS_LOCATION=/opt/globus
endif

if ( -d $GLOBUS_LOCATION ) then
  if ( -r "$GLOBUS_LOCATION/etc/globus-user-env.csh" ) then
    setenv GLOBUS_LOCATION $GLOBUS_LOCATION
    source $GLOBUS_LOCATION/etc/globus-user-env.csh
  endif
endif

if ( $?GLOBUS_TCP_PORT_RANGE ) then
  setenv GLOBUS_TCP_PORT_RANGE "$GLOBUS_TCP_PORT_RANGE"
endif

if ( $?GLOBUS_UDP_PORT_RANGE ) then
  setenv GLOBUS_UDP_PORT_RANGE "$GLOBUS_UDP_PORT_RANGE"
endif

if ( -r /etc/sysconfig/nordugrid ) then
  eval `cat /etc/sysconfig/nordugrid | grep -v '^#' | grep = | sed 's/^/set /'` 
endif

if (! $?NORDUGRID_LOCATION ) then
  set NORDUGRID_LOCATION=/opt/nordugrid
endif

if ( -d $NORDUGRID_LOCATION ) then
  setenv NORDUGRID_LOCATION $NORDUGRID_LOCATION
  setenv PATH `echo "${PATH}" | sed -e "s%:${NORDUGRID_LOCATION}[^:]*%%g" -e "s%^${NORDUGRID_LOCATION}[^:]*:\{0,1\}%%"`
  setenv PATH "${NORDUGRID_LOCATION}/bin:${NORDUGRID_LOCATION}/sbin:${PATH}"
endif

# Only set MANPATH if it is already set. Workaround on systems
# (eg. SuSE) which for some strange reason sets MANPATH
if ( $?MANPATH ) then
  setenv MANPATH "${MANPATH}:${NORDUGRID_LOCATION}/man"
endif

