#ifndef ARCCLI
#define ARCCLI

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <string>
#include <list>

#include <arc/error.h>
#include <arc/resource.h>

/* constants for the whichfile argument to arccat */
#define STDOUT 0
#define STDERR 1
#define GMLOG 2


class ARCCLIError : public ARCLibError {
	public:
		ARCCLIError (std::string message) : ARCLibError(message) {}
};


class SortByHost {
	public:
		bool operator()(const Job& j1, const Job& j2) const {
			return (j1.cluster<j2.cluster);
		}
};


Queue& FindQueueByJob(const Job& job, std::list<Queue>& queues);
std::string QueueStatusByJob(const Job& job, 
                             std::list<Queue>& queues, 
                             bool anonymous, 
                             int timeout);


void arccat (const std::list<std::string>& jobs,
             const std::list<std::string>& clusterselect,
             const std::list<std::string>& clusterreject,
             const std::list<std::string>& status,
             const int whichfile = STDOUT,
             const bool follow = false,
             const int timeout = 0,
             const bool anonymous = false);

void arcclean (const std::list<std::string>& jobs,
               const std::list<std::string>& clusterselect,
               const std::list<std::string>& clusterreject,
               const std::list<std::string>& status,
               const bool force = false,
               const int timeout = 0,
               const bool anonymous = false);

void arcget (const std::list<std::string>& jobs,
             const std::list<std::string>& clusterselect,
             const std::list<std::string>& clusterreject,
             const std::list<std::string>& status,
             const std::string& directory,
             const bool usejobname = false,
             const bool keep = false,
             const int timeout = 0,
             const bool anonymous = false);

void arckill (const std::list<std::string>& jobs,
              const std::list<std::string>& clusterselect,
              const std::list<std::string>& clusterreject,
              const std::list<std::string>& status,
              const bool keep = false,
              const int timeout = 0,
              const bool anonymous = false);

void arcrenew (const std::list<std::string>& jobs,
               const std::list<std::string>& clusterselect,
               const std::list<std::string>& clusterreject,
               const std::list<std::string>& status,
               const int timeout = 0,
               const bool anonymous = false);

void arcresub (const std::list<std::string>& jobs,
               const std::list<std::string>& clusterselect,
               const std::list<std::string>& clusterreject,
               const std::list<std::string>& status,
               const std::list<std::string>& klusterselect,
               const std::list<std::string>& klusterreject,
               const std::list<std::string>& giisurls,
               const std::string& joblistfile,
               const bool dryrun = false,
               const bool dumpxrsl = false,
               const bool unknownattr = false,
               const bool keep = false,
               const int timeout = 0,
               const bool anonymous = false);

void arcresume (const std::list<std::string>& jobs,
                const std::list<std::string>& clusterselect,
                const std::list<std::string>& clusterreject,
                const std::list<std::string>& status,
                const bool renewproxy = false,
                const int timeout = 0,
                const bool anonymous = false);

void arcstat (const std::list<std::string>& jobs,
              const std::list<std::string>& clusterselect,
              const std::list<std::string>& clusterreject,
              const std::list<std::string>& status,
              const std::list<std::string>& giisurls,
              const bool clusters = false,
              const bool longlist = false,
              const int timeout = 0,
              const bool anonymous = false);

std::list<std::string> arcsub (const std::list<std::string>& xrslfiles,
                               const std::list<std::string>& xrslstrings,
                               const std::list<std::string>& clusterselect,
                               const std::list<std::string>& clusterreject,
                               const std::list<std::string>& giisurls,
                               const std::string& joblistfile,
                               const bool dryrun = false,
                               const bool dumpxrsl = false,
                               const bool unknownattr = false,
                               const int timeout = 0,
                               const bool anonymous = false);

void arcsync (const std::list<std::string>& clusterselect,
              const std::list<std::string>& clusterreject,
              const std::list<std::string>& giisurls,
              const bool force = false,
              const int timeout = 0,
              const bool anonymous = false);

void arctest (const unsigned int testjob,
              const bool certificateinfo,
              const bool voinfo,
              const bool resourceinfo,
              const bool configuration,
              const unsigned int runtime,
              const std::list<std::string>& clusterselect,
              const std::list<std::string>& clusterreject,
              const std::list<std::string>& giisurls,
              const std::string& joblistfile,
              const bool dryrun = false,
              const bool dumpxrsl = false,
              const int timeout = 0,
              const bool anonymous = false);

void arcacl (const std::string& file_url,
             const std::string& command,
             int recursion = 0,
             const int timeout = 0);

void arcls(const std::string& dir_url_,
           bool show_details = false,
           bool show_urls = false,
           int recursion = 0,
           int timeout = 0);

void arccp (const std::string& source_url,
            const std::string& destination_url,
            bool secure = false,
            bool passive = true,
            bool force_meta = false,
            int recursion = 0,
            int tries = 0,
            bool verbose = false,
            int timeout = 0);

void arcregister (const std::string& source_url_,
                  const std::string& destination_url_,
                  bool secure = false,
                  bool passive = true,
                  bool force_meta = false,
                  int timeout = 0);

void arcrm(const std::string& file_url,
           bool errcont = false,
           int timeout = 0);

void arctransfer(const std::string& destination,
                 std::list<std::string>& sources,
                 int timeout = 0);

#endif
