%define nordugrid_location /opt/nordugrid
%define monitor_prefix     %{nordugrid_location}/share/gridmonitor

%{?enable_experimental:  %define enable_experimental_option --enable-experimental}
%{!?enable_experimental: %define enable_experimental_option %{nil}}

%{!?release_tag: %define release_tag %{nil}}
%{!?bootstrap: %define bootstrap no}

# Prevent stripping debug information
# Works on redhat and mandrake

%define __os_install_post /usr/lib/rpm/brp-compress

Summary: NorduGrid ToolKit
Name: nordugrid-arc
Version: 0.6.0.2
Release: 1%{release_tag}
URL: http://www.nordugrid.org/
Source: %{name}-%{version}.tar.gz
Prefix: %{nordugrid_location}
License: GPL
Group: NorduGrid
BuildRoot: %{_tmppath}/%{name}-root
BuildRequires: gsoap-devel >= 2.7.2
BuildRequires: libxml2-devel >= 2.4.0
BuildRequires: gpt
BuildRequires: globus_common-devel
BuildRequires: globus_ftp_client-devel
BuildRequires: globus_ftp_control-devel
BuildRequires: globus_gass_transfer-devel
BuildRequires: globus_gsi_credential-devel
BuildRequires: globus_gsi_sysconfig-devel
BuildRequires: globus_gss_assist-devel
BuildRequires: globus_io-devel
BuildRequires: globus_openldap-devel
# Only when building replica
#BuildRequires: globus_replica_catalog-devel
BuildRequires: globus_rls_client-devel
BuildRequires: globus_rsl-devel
#globus_gssapi_gsi
#BuildRequires: globus_openssl
BuildRequires: gettext
BuildRequires: python-devel
BuildRequires: voms-devel
# Simple way to specify a dependency which is very complex across distributions
BuildRequires: /usr/include/ltdl.h

%description
NorduGrid ToolKit

%package ca-utils
Summary: NorduGrid authentication tools
Group: NorduGrid
Requires: wget
%description ca-utils
This package includes authentication utilities. At the moment it is limited to
the CRL update script.

%package client
Summary: NorduGrid client tools
Group: NorduGrid
Requires: nordugrid-arc-libs
Requires: libxml2 >= 2.4.0
Requires: gsoap
%if %{?_vendor}
%if %{_vendor} == "redhat"
# This works on all RH + FC though FC4+ have switched to libtool-ltdl
Requires: libtool-libs
%endif
%if %{_vendor} == "MandrakeSoft"
Requires: libltdl3
%endif
%if %{_vendor} == "suse"
Requires: util-linux
Requires: libtool
#Requires: mysql-shared
%endif
%endif
# Globus dependencies
Requires: globus_callout
Requires: globus_common
Requires: globus_ftp_client
Requires: globus_ftp_control
Requires: globus_gsi_callback
Requires: globus_gsi_cert_utils
Requires: globus_gsi_credential
Requires: globus_gsi_openssl_error
Requires: globus_gsi_proxy_core
Requires: globus_gsi_proxy_ssl
Requires: globus_gsi_sysconfig
Requires: globus_gssapi_gsi
Requires: globus_gss_assist
Requires: globus_io
Requires: globus_openldap
Requires: globus_openssl_module
Requires: globus_rls_client
Requires: globus_rsl
Requires: globus_xio
Requires: gssapi_error
Requires: openssl-globus
Requires: globus_user_env
%description client
This package contains the NorduGrid client tools.

%package compat
Summary: NorduGrid 0.4 client tools
Group: NorduGrid
Requires: nordugrid-arc-client
Requires: libxml2 >= 2.4.0, perl
Requires: gsoap
%if %{?_vendor}
%if %{_vendor} == "redhat"
# This works on all RH + FC though FC4+ have switched to libtool-ltdl
Requires: libtool-libs
%endif
%if %{_vendor} == "MandrakeSoft"
Requires: libltdl3
%endif
%if %{_vendor} == "suse"
Requires: util-linux
Requires: libtool
%endif
%endif
# Globus dependencies
Requires: globus_callout
Requires: globus_common
Requires: globus_ftp_client
Requires: globus_ftp_control
Requires: globus_gsi_callback
Requires: globus_gsi_cert_utils
Requires: globus_gsi_credential
Requires: globus_gsi_openssl_error
Requires: globus_gsi_proxy_core
Requires: globus_gsi_proxy_ssl
Requires: globus_gsi_sysconfig
Requires: globus_gssapi_gsi
Requires: globus_gss_assist
Requires: globus_io
Requires: globus_openldap
Requires: globus_openssl_module
Requires: globus_rls_client
Requires: globus_rsl
Requires: globus_xio
Requires: gssapi_error
Requires: openssl-globus
Requires: globus_user_env
%description compat
This package contains the old 0.4 NorduGrid client tools.

%package doc
Summary: NorduGrid Documentation
Group: NorduGrid
%description doc
This package includes the NorduGrid documentation.

%package gridmap-utils
Summary: NorudGrid authorization tools
Group: NorduGrid
Requires: perl
#Requires: curl
Obsoletes: nordugrid-auth <= 0.23.3
%description gridmap-utils
This package contains the NorduGrid authorization machinery.

%if %{?enable_experimental:1}%{!?enable_experimental:0}
%package gui
Summary: NorduGrid Qt Graphical User Interface
Group: NorduGrid
Requires: nordugrid-arc-libs
%description gui
Graphical Qt frontend for the NorduGrid Toolkit.
%endif

%package libs-devel
Summary: NorduGrid ARC development files
Group: NorduGrid
Requires: nordugrid-arc-libs
%description libs-devel
This package includes the files for developing application using the NorduGrid ARC
libraries. It includes header files and static libraries.

%package libs
Summary: NorduGrid ARC runtime libraries
Group: NorduGrid
Requires: libxml2 >= 2.4.0
Requires: gsoap
%if %{?_vendor}
%if %{_vendor} == "redhat"
# This works on all RH + FC though FC4+ have switched to libtool-ltdl
Requires: libtool-libs
%endif
%if %{_vendor} == "MandrakeSoft"
Requires: libltdl3
%endif
%if %{_vendor} == "suse"
Requires: util-linux
Requires: libtool
%endif
%endif
# Globus dependencies in libarclib and libarcdata
Requires: globus_callout
Requires: globus_common
Requires: globus_ftp_control
Requires: globus_gsi_callback
Requires: globus_gsi_cert_utils
Requires: globus_gsi_credential
Requires: globus_gsi_openssl_error
Requires: globus_gsi_proxy_core
Requires: globus_gsi_proxy_ssl
Requires: globus_gsi_sysconfig
Requires: globus_gssapi_gsi
Requires: globus_gss_assist
Requires: globus_io
Requires: globus_openldap
Requires: globus_openssl_module
Requires: globus_xio
Requires: gssapi_error
Requires: openssl-globus
# Only needed by libarclib
Requires: globus_rsl
# Only needed by libarcdata
Requires: globus_ftp_client
Requires: globus_rls_client
%description libs
This package contains the NorduGrid ARC runtime libraries.

%package logger-server
Summary: NorduGrid logger server
Group: NorduGrid
Requires: nordugrid-arc-libs
Requires: nordugrid-arc-server

Requires: gsoap
%if %{?_vendor}
%if %{_vendor} == "redhat"
# This works on all RH + FC though FC4+ have switched to libtool-ltdl
#Requires: mysql
%endif
%if %{_vendor} == "MandrakeSoft"
#Requires: MySQL-shared
%endif
%if %{_vendor} == "suse"
#Requires: mysql-shared
%endif
%endif
# Direct Globus dependencies
Requires: globus_common
Requires: globus_io
Requires: globus_openldap
%description logger-server
This package contains the NorduGrid logger server. You will also need
the general server package.

%package monitor
Summary: NorduGrid Grid Monitor
Group: NorduGrid
Prefix: %{monitor_prefix}
%description monitor
This package includes the scripts for the NorduGrid Grid Monitor. The
main monitor can be viewed from the NorduGrid web site. This package
requires a web server.

%package python
Summary: NorduGrid ARC python bindings
Group: NorduGrid
Requires: nordugrid-arc-libs
%description python
This package contains the NorduGrid ARC python bindings.

%package server
Summary: NorduGrid grid-manager, gridftp server and information system
Group: NorduGrid
Requires: nordugrid-arc-libs
Requires: libxml2 >= 2.4.0, perl
Requires: gsoap
Requires: voms
%if %{?_vendor}
%if %{_vendor} == "redhat"
Requires: time
# This works on all RH + FC though FC4+ have switched to libtool-ltdl
Requires: libtool-libs
#Requires: mysql
%endif
%if %{_vendor} == "MandrakeSoft"
Requires: time
Requires: libltdl3
#Requires: MySQL-shared
%endif
%if %{_vendor} == "suse"
Requires: util-linux
Requires: libtool
#Requires: mysql-shared
%endif
%endif
# Globus dependencies
Requires: globus_callout
Requires: globus_common
Requires: globus_ftp_client
Requires: globus_ftp_control
Requires: globus_gass_transfer
Requires: globus_gsi_callback
Requires: globus_gsi_cert_utils
Requires: globus_gsi_credential
Requires: globus_gsi_openssl_error
Requires: globus_gsi_proxy_core
Requires: globus_gsi_proxy_ssl
Requires: globus_gsi_sysconfig
Requires: globus_gssapi_gsi
Requires: globus_gss_assist
Requires: globus_io
Requires: globus_openldap
Requires: globus_openssl_module
Requires: globus_rls_client
Requires: globus_rsl
Requires: globus_xio
Requires: gssapi_error
Requires: globus_mds_common
Requires: globus_mds_gris
Requires: globus_ldapmodules
Requires: globus_mds_back_giis
Requires: openssl-globus
%description server
This package contains the NorduGrid server binaries and information system.
This includes the grid-manager, gridftpd and information providers.

%prep
%setup -q

%build
if test "%{bootstrap}" = "yes" ; then
  ./bootstrap
fi

CXXFLAGS="$RPM_OPT_FLAGS" CFLAGS="$RPM_OPT_FLAGS" \
  ./configure --prefix=%{nordugrid_location} --disable-pkgdirs \
              --with-monitor-prefix=%{monitor_prefix} %{enable_experimental_option} \
              --enable-docs && \
  make

%install
rm -rf $RPM_BUILD_ROOT
make install DESTDIR=$RPM_BUILD_ROOT

rm -f ${RPM_BUILD_ROOT}%{nordugrid_location}/lib/*plugin*{.a,.la}
rm -f ${RPM_BUILD_ROOT}%{nordugrid_location}/lib/*logger*{.a,.la}
rm -f ${RPM_BUILD_ROOT}%{nordugrid_location}/lib/*se*{.a,.la}
rm -f ${RPM_BUILD_ROOT}%{nordugrid_location}/lib/*srm*{.a,.la}
rm -f ${RPM_BUILD_ROOT}${prefix}/lib/python2.3/site-packages/*arclib*{.a,.la,.pyc,.pyo}

# Make filelists
for i in build/*.filelist ; do
  build/mkfilelist $i rpm > `basename $i`
done

%clean
rm -rf $RPM_BUILD_ROOT

%files ca-utils -f ca-utils.filelist
%defattr(-,root,root)

%files client -f client.filelist
%defattr(-,root,root)

%files compat -f compat.filelist
%defattr(-,root,root)

%files doc -f doc.filelist
%defattr(-,root,root)

%files gridmap-utils -f gridmap-utils.filelist
%defattr(-,root,root)

%if %{?enable_experimental:1}%{!?enable_experimental:0}
%files gui -f gui.filelist
%defattr(-,root,root)
%endif

%files libs-devel -f libs-devel.filelist
%defattr(-,root,root)

%files libs -f libs.filelist
%defattr(-,root,root)

%files logger-server -f logger-server.filelist
%defattr(-,root,root)

%files monitor -f monitor.filelist
%defattr(-,root,root)

%files python -f python.filelist
%defattr(-,root,root)

%files server -f server.filelist
%defattr(-,root,root)

%changelog
* Fri Mar 30 2007 Anders Waananen <waananen@nbi.dk> - 0.6.0.2-1%{release_tag}
- Specfile automatically generated

* Fri May  3 2002 Anders Waananen <waananen@nbi.dk>
- Initial build.
