#!/bin/sh

dir=`dirname $0`
dir=`cd $dir; pwd`

experimental="gui"

cat $dir/spec.head

for i in $dir/*.summary
do
  subpkg=`basename $i .summary`
  eks="" 
  for e in $experimental
  do
    test x$e = x$subpkg && eks="yes"
  done
  echo
  test x$eks = "xyes" && echo "%if %{?enable_experimental:1}%{!?enable_experimental:0}"
  echo "%package $subpkg"
  echo "Summary: `cat $dir/$subpkg.summary|head -1`"
  echo "Group: NorduGrid"
  test -f $dir/$subpkg.requires && cat $dir/$subpkg.requires
  test -f $dir/$subpkg.prefix   && cat $dir/$subpkg.prefix
  echo "%description $subpkg"
  cat $dir/$subpkg.desc
  test x$eks = "xyes" && echo "%endif"
done

cat $dir/spec.body

for i in $dir/*.summary
do
  subpkg=`basename $i .summary`
  eks="" 
  for e in $experimental
  do
    test x$e = x$subpkg && eks="yes"
  done
  echo
  test x$eks = "xyes" && echo "%if %{?enable_experimental:1}%{!?enable_experimental:0}"
  echo "%files $subpkg -f $subpkg.filelist"
  echo "%defattr(-,root,root)"
  test x$eks = "xyes" && echo "%endif"
done

echo
date=`date "+%a %b %d %Y"`
version=`cat ../VERSION`
release=`cat spec.head|grep "^Release: " | cut -f2- -d' '`
cat <<EOF
%changelog
* $date Anders Waananen <waananen@nbi.dk> - $version-$release
- Specfile automatically generated

EOF
cat $dir/spec.changelog


