#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <cstdio>

#include <arc/common.h>
#include <arc/configcore.h>
#include <arc/giis.h>

#ifdef HAVE_LIBINTL_H
#include <libintl.h>
#define _(A) dgettext("arclib", (A))
#else
#define _(A) (A)
#endif


std::list<URL> GetGIISList() {

	std::list<std::string> GIISFileLocations;

	std::string home = GetEnv("HOME");
	if (!home.empty()) {
		Config conf = ReadConfig(home + "/.arc/client.conf");
		GIISFileLocations = conf.ConfValue("client/giis");
		if (!GIISFileLocations.empty())
			return ConvertToURLs(GIISFileLocations);
		GIISFileLocations = conf.ConfValue("common/giis");
		if (!GIISFileLocations.empty())
			return ConvertToURLs(GIISFileLocations);

		// Old style configuration for backward compatibility
		GIISFileLocations = ReadFile(home + "/.nggiislist");
		if (!GIISFileLocations.empty())
			return ConvertToURLs(GIISFileLocations);
	}

	std::string nglocation = GetEnv("ARC_LOCATION");
	if (nglocation.empty()) nglocation = GetEnv("NORDUGRID_LOCATION");
	if (!nglocation.empty()) {
		Config conf = ReadConfig(nglocation + "/etc/arc.conf");
		GIISFileLocations = conf.ConfValue("client/giis");
		if (!GIISFileLocations.empty())
			return ConvertToURLs(GIISFileLocations);
		GIISFileLocations = conf.ConfValue("common/giis");
		if (!GIISFileLocations.empty())
			return ConvertToURLs(GIISFileLocations);

		// Old style configuration for backward compatibility
		GIISFileLocations = ReadFile(nglocation + "/etc/giislist");
		if (!GIISFileLocations.empty())
			return ConvertToURLs(GIISFileLocations);
	}

	Config conf = ReadConfig("/etc/arc.conf");
	GIISFileLocations = conf.ConfValue("client/giis");
	if (!GIISFileLocations.empty())
		return ConvertToURLs(GIISFileLocations);
	GIISFileLocations = conf.ConfValue("common/giis");
	if (!GIISFileLocations.empty())
		return ConvertToURLs(GIISFileLocations);

	// Old style configuration for backward compatibility
	GIISFileLocations = ReadFile("/etc/giislist");
	if (!GIISFileLocations.empty())
		return ConvertToURLs(GIISFileLocations);

	throw GIISError(_("No GIIS list found in standard locations"));
}


std::list<URL> ConvertToURLs(std::list<std::string> GIISList) {

	std::list<URL> urllist;
	std::list<std::string>::iterator it;

	for (it = GIISList.begin(); it != GIISList.end(); it++) {
		urllist.push_back( URL(*it) );
	}

	return urllist;
}
