#ifndef ARCLIB_STANDARDBROKERS
#define ARCLIB_STANDARDBROKERS

#include <list>

#include <arc/broker.h>

/** Cluster broker. */
class ClusterBroker : public Broker {
	public:
		void DoBrokering(std::list<Target>& targets);

	protected:
		bool RelationCheck(Target& target, XrslRelation& relation);
};

/** Queue broker. */
class QueueBroker : public Broker {
	public:
		void DoBrokering(std::list<Target>& targets);

	protected:
		bool RelationCheck(Target& target, XrslRelation& relation);
};

/** Count broker. */
class CountBroker : public Broker {
	public:
		void DoBrokering(std::list<Target>& targets);

	protected:
		bool RelationCheck(Target& target, XrslRelation& relation);
};

/** Memory broker. */
class MemoryBroker : public Broker {
	public:
		void DoBrokering(std::list<Target>& targets);

	protected:
		bool RelationCheck(Target& target, XrslRelation& relation);
};


/** Architecture broker. */
class ArchitectureBroker : public Broker {
	public:
		void DoBrokering(std::list<Target>& targets);

	protected:
		bool RelationCheck(Target& target, XrslRelation& relation);
};


/** NodeAccess broker. */
class NodeAccessBroker : public Broker {
	public:
		void DoBrokering(std::list<Target>& targets);

	protected:
		bool RelationCheck(Target& target, XrslRelation& relation);
};


/** Middleware broker. */
class MiddlewareBroker : public Broker {
	public:
		void DoBrokering(std::list<Target>& targets);

	protected:
		bool RelationCheck(Target& target, XrslRelation& relation);
};


/** RuntimeEnvironment broker. */
class RuntimeEnvironmentBroker : public Broker {
	public:
		void DoBrokering(std::list<Target>& targets);

	protected:
		bool RelationCheck(Target& target, XrslRelation& relation);
};


/** Opsys broker. */
class OpsysBroker : public Broker {
	public:
		void DoBrokering(std::list<Target>& targets);

	protected:
		bool RelationCheck(Target& target, XrslRelation& relation);
};


/** CpuTime broker. */
class CpuTimeBroker : public Broker {
	public:
		void DoBrokering(std::list<Target>& targets);

	protected:
		bool RelationCheck(Target& target, XrslRelation& relation);
};


/** FreeCpusSort broker. */
class FreeCpusSortBroker : public Broker {
	public:
		void DoBrokering(std::list<Target>& targets);

	protected:
		/** This method compares two targets and returns the preferred one.
		 *  The one target enough free cpus for the job is preferred. If both
		 *  have free cpus for the user, the target with the fastest CPU's is
		 *  chosen. If none has free cpus for the user, the one with the
		 *  shortest queue-length (divided by the number of total CPU's) is
		 *  preferred.
		 */
		bool Compare(Target& target1, Target& target2);
};


/** RandomSort broker. */
class RandomSortBroker : public Broker {
	public:
		void DoBrokering(std::list<Target>& targets);

	protected:
		bool Compare(Target& target1, Target& target2);
};


/** LifeTime broker. */
class LifeTimeBroker : public Broker {
	public:
		void DoBrokering(std::list<Target>& targets);

	protected:
		bool RelationCheck(Target& target, XrslRelation& relation);
};


/** Disk broker. */
class DiskBroker : public Broker {
	public:
		void DoBrokering(std::list<Target>& targets);

	protected:
		bool RelationCheck(Target& target, XrslRelation& relation);
};

/** This method performs brokering with all the standard brokers
 *  given above. Any piece of brokering code should probably call this
 *  method to remove clearly false targets.
 */
void PerformStandardBrokering(std::list<Target>& targets);

#endif // ARCLIB_STANDARDBROKERS
