/**
 * This file contains interface specification for resource presentation
 * in ARC.
 * For information about the different variables see nordugrid.schema
 * file in nordugrid/infosystem
 */
#ifndef ARCLIB_RESOURCE
#define ARCLIB_RESOURCE

#include <list>
#include <map>
#include <string>

#include <arc/datetime.h>
#include <arc/runtimeenvironment.h>

class Queue;

/**
 * Class to represent the description of a job.
 * See nordugrid.schema for information about variables.
 */
class Job {

	public:
		Job();

		std::string id;
		std::string owner;
		std::string cluster;
		std::string queue;
		std::string sstdout;
		std::string sstderr;
		std::string sstdin;
		std::string rerunable;
		long requested_cpu_time;
		long requested_wall_time;
		std::string status;
		int queue_rank;
		std::string comment;
		std::string submission_ui;
		Time submission_time;
		Time completion_time;
		long used_cpu_time;
		long used_wall_time;
		Time erase_time;
		int used_memory;
		std::string errors;
		int exitcode;
		std::string job_name;
		std::list<RuntimeEnvironment> runtime_environments;
		int cpu_count;
		std::list<std::string> execution_nodes;
		std::string gmlog;
		std::string client_software;
		Time proxy_expire_time;
		Time mds_validfrom;
		Time mds_validto;
};

/**
 * Class to represent the description of a user.
 * See nordugrid.schema for information about variables.
 */
class User {

	public:
		User();

		std::string name;
		std::string subject_name;
		std::map<long,int> free_cpus;
		long long free_diskspace;
		int queue_length;
		Time mds_validfrom;
		Time mds_validto;
};



/**
 * Class to represent the description of a cluster.
 * See nordugrid.schema for information about variables.
 */
class Cluster {

	public:
		Cluster();

		std::string hostname;

		std::list<Queue> queues;

		std::string alias;
		std::list<std::string> owners;
		std::string location;
		std::string issuer_ca;
		std::string issuer_ca_hash;
		std::list<std::string> trusted_ca;
		std::list<std::string> cluster_acl;
		std::string contact;
		std::string interactive_contact;
		std::list<std::string> support;
		std::string lrms_type;
		std::string lrms_version;
		std::string lrms_config;
		std::string architecture;
		std::list<RuntimeEnvironment> operating_systems;
		bool homogeneity;
		std::string node_cpu;
		float cpu_freq;
		int node_memory;
		int total_cpus;
		std::map<int,int> cpu_distribution;
		long long session_dir_free;
		long long session_dir_total;
		long session_dir_lifetime;
		long long cache_free;
		long long cache_total;
		std::list<RuntimeEnvironment> runtime_environments;
		std::list<std::string> local_se;
		std::list<RuntimeEnvironment> middlewares;
		int total_jobs;
		int used_cpus;
		int queued_jobs;
		int prelrms_queued;
		std::list<std::string> node_access;
		std::string comment;
		std::map<std::string,float> benchmarks;
		Time mds_validfrom;
		Time mds_validto;
};



/**
 * Class to represent the description of a queue (target).
 * See nordugrid.schema for information about variables.
 */
class Queue {

	public:
		Queue();

		Cluster cluster;

		std::string name;

		std::list<Job> jobs;
		std::list<User> users;

		std::string status;
		int running;
		int queued;
		int max_running;
		int max_queuable;
		int max_user_run;
		long max_cpu_time;
		long min_cpu_time;
		long default_cpu_time;
		std::string scheduling_policy;
		int total_cpus;
		std::string node_cpu;
		float cpu_freq;
		int node_memory;
		std::string architecture;
		std::list<RuntimeEnvironment> operating_systems;
		int grid_running;
		int grid_queued;
		int local_queued;
		int prelrms_queued;
		bool homogeneity;
		std::map<std::string,float> benchmarks;
		std::string comment;
		std::list<RuntimeEnvironment> runtime_environments;
		std::list<RuntimeEnvironment> middlewares;
		Time mds_validfrom;
		Time mds_validto;
};



/**
 * Class to represent the description of a storage element.
 * See nordugrid.schema for information about variables.
 */
class StorageElement {

	public:
		StorageElement();

		std::string name;
		std::string alias;
		std::string type;
		long long free_space;
		std::string url;
		std::list<std::string> auth_users;
		std::string location;
		std::list<std::string> owners;
		std::string ca_issuer;
		std::string ca_issuer_hash;
		std::list<std::string> trusted_ca;
		std::list<std::string> se_acl;
		std::string access_control;
		long long total_space;
		std::list<RuntimeEnvironment> middlewares;
		std::string comment;
		Time mds_validfrom;
		Time mds_validto;
};



/**
 * Class to represent the description of a replica catalog.
 * See nordugrid.schema for information about variables.
 */
class ReplicaCatalog {

	public:
		ReplicaCatalog();

		std::string name;
		std::string alias;
		std::string base_url;
		std::list<std::string> auth_users;
		std::string location;
		std::list<std::string> owners;
		std::string ca_issuer;
		std::string ca_issuer_hash;
		Time mds_validfrom;
		Time mds_validto;
};


#endif // ARCLIB_PRESENTAIION

