#ifndef ARCLIB_GLOBUSMODULES
#define ARCLIB_GLOBUSMODULES

#include <arc/error.h>

/** Exception class thrown when a Globus module fails to initialize. */
class GlobusModuleError : public ARCLibError {
	public:
		/** Standard exception class constructor. */
		GlobusModuleError(std::string message) : ARCLibError(message) {}
};


/** A general class that takes care of activating and deactivating Globus
 *  modules automatically. Specific examples are shown below.
 *  A piece of code that wishes to activate a specific Globus module just
 *  needs to define a variable of the given type. When the variable goes
 *  out of scope, the Globus module is automatically deactivated.
 */
#define GLOBUSMODULE_CLASS_HEADER(class_name) \
class class_name { \
	public: \
		class_name() throw(GlobusModuleError); \
		~class_name(); \
		bool isactive(); \
	private: \
		bool activated; \
};

/** Class to activate and deactivate the Globus Common Module. */
GLOBUSMODULE_CLASS_HEADER(GlobusCommonModule);

/** Class to activate and deactivate the Globus IO Module. */
GLOBUSMODULE_CLASS_HEADER(GlobusIOModule);

/** Class to activate and deactivate the Globus GASS Transfer Module. */
GLOBUSMODULE_CLASS_HEADER(GlobusGASSTransferModule);

/** Class to activate and deactivate the Globus GASS Copy Module. */
GLOBUSMODULE_CLASS_HEADER(GlobusGASSCopyModule);

/** Class to activate and deactivate the Globus FTP Control Module. */
GLOBUSMODULE_CLASS_HEADER(GlobusFTPControlModule);

/** Class to activate and deactivate the Globus FTP Client Module. */
GLOBUSMODULE_CLASS_HEADER(GlobusFTPClientModule);

/** Class to activate and deactivate the Globus Replica Catalog Module. */
GLOBUSMODULE_CLASS_HEADER(GlobusReplicaCatalogModule);

/** Class to activate and deactivate the Globus GSI GSSAPI Module. */
GLOBUSMODULE_CLASS_HEADER(GlobusGSIGSSAPIModule);

/** Class to activate and deactivate the Globus Error Module. */
GLOBUSMODULE_CLASS_HEADER(GlobusErrorModule);

/** Class to activate and deactivate the Globus RSL Module. */
GLOBUSMODULE_CLASS_HEADER(GlobusRSLModule);

/** Class to activate and deactivate the Globus GSI Credential Module. */
GLOBUSMODULE_CLASS_HEADER(GlobusGSICredentialModule);

/** Class to activate and deactivate the Globus GSI Sysconfig Module. */
GLOBUSMODULE_CLASS_HEADER(GlobusGSISysconfigModule);

/** Class to activate and deactivate the Globus RLS Client Module. */
GLOBUSMODULE_CLASS_HEADER(GlobusRLSClientModule);

#undef GLOBUSMODULE_CLASS_HEADER

#endif // ARCLIB_GLOBUSMODULES
