#include "ninfg_arc_is.h"

#include <iostream>
#include <getopt.h>
#include <arc/notify.h>
#include <arc/error.h>

int main(int argc,char* argv[]) {
  try {
    Notify::getNotifier()->SetOutStream(Notify::getNotifier()->GetNullStream());
    Notify::getNotifier()->SetNotifyLevel(WARNING);
  } catch (ARCLibError e) { };

  int o;
  while((o=getopt(argc,argv,"hl:H:P:b:M:A:B")) != -1) {
    switch(o) {
      case ':': { std::cout<<"Missing argument\n"; return 1; };
      case '?': { std::cout<<"Unrecognized option\n"; return 1; };
      case '.': { return 1; };
      case 'h': {
        std::cout<<"ng_invoke_server.ARC [-h] [-l log_file] [-H hostname] [-P port] [-b ldap_base_name] [-M MPI_RTE] [-A parallel_RTE] [-B BLACS_RTE] "<<std::endl;
         return 0;
      };
      case 'l': {
        std::ofstream* logstream = new std::ofstream(optarg);
        if(logstream->is_open()) {
          try {
            Notify::getNotifier()->SetOutStream(*logstream);
          } catch (ARCLibError e) { };
        };
      }; break;
      case 'H': {
        NinfGJob::default_hostname=optarg;
      }; break;
      case 'P': {
        NinfGJob::default_port=atoi(optarg);
      }; break;
      case 'b': {
        NinfGJob::basename=optarg;
      }; break;
      case 'M': {
        NinfGJob::rte_mpi=optarg;
      }; break;
      case 'A': {
        NinfGJob::rte_parallel=optarg;
      }; break;
      case 'B': {
        NinfGJob::rte_blacs=optarg;
      }; break;
      default: { std::cout<<"Option processing error\n"; return 1; };
    };
  };

  NinfGJobs jobs;
  NinfGRequests requests;
  NinfGRequestProcessor req_processor(requests,jobs);
  NinfGJobSubmitter job_submitter(requests,jobs);
  NinfGJobMonitor job_monitor(jobs);

  while(true) sleep(600);

  return 0;
}

