#
# Minisat result object, and a parser for output
#

import re

class ms_obj:
    name = 'unknown'
    seed = 'undef'

    def __init__(self, name, seed, runtime, sat, status):
        self.name = name
        self.runtime = runtime
        self.sat = sat
        self.status = status
        self.seed = seed

    def __str__(self):
        output = "incomplete"
        if self.status == "sat" or \
            self.status == "unsat" or \
            self.status == "timeout":
            output = "(%f, %s)" % (self.runtime, self.status)
        if self.seed != "undef":
            output = " ".join([output, str(self.seed)])

        return output

def ms_parse(file):
    sat = -1
    runtime = -1
    name = 'unknown'
    timeout = False
    seed = -1

    body = open(file).read()

    mo = re.search("file[ \t]*=[ \t]*'([^']*)'", body, re.M)
    if mo:
        name = mo.group(1)
    else:
        pass

    mo = re.search("Using seed[ \t]*([0-9][0-9]*)", body, re.M)
    if mo:
        seed = int(mo.group(1))

    mo = re.search("^UNSATISFIABLE", body, re.M)
    if mo:
        sat = False

    mo = re.search("^SATISFIABLE", body, re.M)
    if mo:
        assert (sat == -1)
        sat = True

    mo = re.search("^TIME OUT", body, re.M)
    if mo:
        assert (sat == -1)
        timeout = True

    mo = re.search("^CPU time[ \t]*:[ \t]*([0-9][0-9]*\.[0-9][0-9]*) s",
                    body, re.M)

    if mo:
        runtime = float(mo.group(1))
    else:
        pass
    status = "incomplete"

    if (runtime >= 0):
        if (sat == False):
            status = "unsat"
        if (sat == True):
            status = "sat"
        if (timeout == True):
            status = "timeout"

    return ms_obj(name, seed, runtime, sat, status)


