#!/bin/sh

if [ $# != 3 ]; then
    echo "Usage: $0 timeout seed file"
    exit 1
fi

timeout=$1
seed=$2
file=$3

echo "file = '$file'"
echo `hostname`

chmod +x ./solver
./solver -t $timeout -s $seed $file

rval=$?

if [ $rval == 0 ]; then
    exit 0; # sat
else
    exit 1; # Strange value
fi

