/* $Id: userside.h,v 1.2 2007-11-08 15:43:40 aehyvari Exp $ */
/* start[./copyright.txt] */
/* Including data from file ./copyright.txt */
/* file opened */
/* Reading 775 bytes of data */
/* Start of include */
/*
 * Copyright 2007 Antti Hyvrinen
 *
 * This file is part of GridJM.
 *
 * GridJM is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * GridJM is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GridJM; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/* End of include */
/* stop[./copyright.txt] */
/* User side communication module. */
#include <queue>
#include <list>
#include <pthread.h>
#include <signal.h>
#include "common.h"
#include "instrumentation.h"

/* Find sensible values for these: */
#define BUFSIZE 1024 // The initial size for the xrsl buffer
#define READSIZE 1024 // The size of socket reads

void *user_listener(void *pointer);

class UserSide {
    public:
        UserSide(Instrumenter *inst, struct arguments *a, int pipe_read,
                queue<char*> *new_jobs, pthread_mutex_t *new_jobs_lock,
                list<PidJob*> *forked_downloads,
                pthread_mutex_t *forked_dl_lock,
                sigset_t *sigmask, sigset_t *orig_sigmask);
        int start();
        /* Args an Listen are public so that thread bootstrapper can
         * find it. Does it really matter?
         */
        struct arguments *args;
        int Listen(bool uds);
    private:
        int HandleConnection(int socket_hanlde);
        void GetMoreJobs();
        void InsertXrsl(char *buf);
        void RequestJob(char *buf);
        void WaitPids();
        pthread_mutex_t *new_jobs_lock;
        int *num_current_jobs;
        list<PidJob*> *forked_downloads;
        pthread_mutex_t *forked_dl_lock;
        queue<char*> *new_jobs;
        sigset_t *sigmask;
        sigset_t *orig_sigmask;
        fd_set *rfds;
        int pipe_read;
        int xrslsocket;
        Instrumenter *inst;
};
