#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include "inslangutil.h"
#include "parsebuffer.h"

#define NULL 0

#define MAXFILESZ 1024*1024

// These are moved to inslang.y 
/*
void printTree(struct Node *n, int indent) {

    int i;
    for (i = 0; i < indent; i++)
        printf(" ");

    printf("%s, %s\n", n->type, n->value);

    if (n->children != NULL) {
        struct Node *first;
        for (first = n->children->first;
                first != NULL;
                first = first->next) {
            printTree(first, indent + 1);
        }
    }
    return;
}

void freeTree(struct Node *n) {

    if (n->children != NULL) {
        struct Node *first;
        for (first = n->children->first;
                first != NULL;) {
            struct Node *next = first->next;
            freeTree(first);
            first = next;
        }

        free(n->children);

    }

    if (n->type  != NULL) free(n->type);
    if (n->value != NULL) free(n->value);
    free(n);

}
*/
int main(int argc, char **argv)
{
    if (argc != 2) {
        printf("Usage: %s insfile\n", argv[0]);
        return -1;
    }

    int fd = open(argv[1], O_RDONLY);
    if (fd == -1) {
        perror("open()");
        return -1;
    }

    char *parsebuf = (char *) malloc(MAXFILESZ);

    if (read(fd, parsebuf, MAXFILESZ) == -1) {
        perror("read()");
        return -1;
    }

    struct Node* p = parsestring(parsebuf);
    if (p != 0) {
        printf("Parse ok\n");
        printTree(p, 0);
        freeTree(p);
    }
    else
        printf("Parse 1 failed\n");

    return 0;
}
