#ifndef SPLITLANGUTIL_H
# define SPLITLANGUITL_H

struct strlistel {
    struct strlistel*   next;
    char*               name;
};

struct strlist {
    struct strlistel*   first;
    struct strlistel*   last;
};

struct strllistel {
    struct strllistel*  next;   // Really a struct strllistel*
    struct strlist*     name;
};

struct strllist {
    struct strllistel*  first;
    struct strllistel*  last;
};

struct t_str {
    char *contents;
};

struct timescale {
    double start;
    double stop;
};

struct Node {
    char *              type;
    struct NodeList*    children;
    char *              value;
    struct Node*        next;
};

struct NodeList {
    struct Node*  first;
    struct Node*  last;
};

/* Describes a problem */
struct problem {
    struct timescale*           ts;
    struct simeventsc_l*        se;
/*
    struct strlist* files;      // files of the problem
    struct strllist* additional; // more constraints
    char*       name;           // name of the problem
*/
};

/**
 * A wrapper for parsing a given string, this is the entry point
 */
struct Node* parsestring(char *str);
/**
 * Something for debugging.  Print the syntax tree
 */
void printTree(struct Node *n, int indent);

/**
 * release the memory occupied by the tree
 */
void freeTree(struct Node* n);

#endif
