dnl $Id: gridjm.m4,v 1.1 2007-11-08 16:10:30 aehyvari Exp $

AC_DEFUN([GRIDJM_INIT],
[
dnl
dnl gSOAP
dnl
gsoap=yes
AC_ARG_WITH(gsoap-location,
  [  --with-gsoap-location=<PATH>         Specify the gSOAP installation path. [[autodetect]]],
  [gsoap_location=$with_gsoap_location],
  [gsoap_location=/usr/local/gsoap]
)

dnl
dnl Find gSoap library
dnl Ps: we should really use pkgconfig: PKG_CHECK_MODULES(GSOAP, gsoap++ >= 2.7.2)
dnl
  for lib in lib64 lib
  do
    if test -f "$gsoap_location/$lib/libgsoap++.la"
    then
      GSOAP_LIBS="-L$gsoap_location/$lib -lgsoap++"
      break
    fi
    if test -f "$gsoap_location/$lib/libgsoap++.a"
    then
      GSOAP_LIBS="-L$gsoap_location/$lib -lgsoap++"
      break
    fi
    if test -f "$gsoap_location/$lib/libgsoap++.so"
    then
      GSOAP_LIBS="-L$gsoap_location/$lib -lgsoap++"
      break
    fi
  done
  if test x"$GSOAP_LIBS" = x ; then
    AC_MSG_WARN([No gSOAP library found. Please install gSOAP.])
    gsoap=
  fi

if test "$gsoap" == "yes"; then
  :
else
  AC_MSG_WARN([gSoap not found - many things will not be built])
fi

AC_SUBST(GSOAP_LIBS)
AC_SUBST(GSOAP_LOCATION,$gsoap_location)
AM_CONDITIONAL(HAVE_GSOAP, test "x$gsoap" = "xyes")

dnl
dnl DEFAULT_GLOBUS_LOCATION
dnl
AC_MSG_CHECKING(for DEFAULT_GLOBUS_LOCATION)
AC_ARG_WITH(default-globus-location,
  [  --with-default-globus-location=<PATH>  Specify the default globus location. [[/opt/globus]]],
  [
    DEFAULT_GLOBUS_LOCATION="$withval"
  ],
  [
    DEFAULT_GLOBUS_LOCATION="/opt/globus"
  ]
)
AC_MSG_RESULT($DEFAULT_GLOBUS_LOCATION)  
AC_DEFINE_UNQUOTED(DEFAULT_GLOBUS_LOCATION,"$DEFAULT_GLOBUS_LOCATION",[Default Globus installation path])
AC_SUBST(DEFAULT_GLOBUS_LOCATION)

dnl
dnl GLOBUS_LOCATION
dnl
AC_MSG_CHECKING(for GLOBUS_LOCATION)
AC_ARG_WITH(globus-location,
  [  --with-globus-location=<PATH>        Specify the globus installation path. [[/opt/globus]]],
  [
    GLOBUS_LOCATION="$withval"
    export GLOBUS_LOCATION
  ],
  [
    if test "x$GLOBUS_LOCATION" = "x"; then
      GLOBUS_LOCATION=$DEFAULT_GLOBUS_LOCATION
      export GLOBUS_LOCATION
    fi
  ]
)
if test -d $GLOBUS_LOCATION; then
  AC_MSG_RESULT($GLOBUS_LOCATION)  
  if test "$LD_LIBRARY_PATH" = ""
    export LD_LIBRARY_PATH="$GLOBUS_LOCATION/lib"
  then
    export LD_LIBRARY_PATH="$GLOBUS_LOCATION/lib:$LD_LIBRARY_PATH"
  fi
else
  AC_MSG_RESULT(not found)  
  AC_MSG_WARN(disabling Globus - not many things will work)
  GLOBUS_LOCATION=
fi
AC_SUBST(GLOBUS_LOCATION)

dnl
dnl GPT_LOCATION
dnl
DEFAULT_GPT_LOCATION=/opt/gpt
AC_SUBST(DEFAULT_GPT_LOCATION)
AC_MSG_CHECKING(for GPT_LOCATION)
AC_ARG_WITH(gpt-location,
  [  --with-gpt-location=<PATH>           Specify the gpt installation path. [[/opt/gpt]]],
  [
    if test "x$withval" = "x"; then
      if test "x$GPT_LOCATION" = "x"; then
	GPT_LOCATION=$DEFAULT_GPT_LOCATION
	if test ! -d $GPT_LOCATION; then
	  GPT_LOCATION=$GLOBUS_LOCATION
	fi
	export GPT_LOCATION
      fi
    else
      GPT_LOCATION="$withval"
      export GPT_LOCATION
    fi
  ],
  [
    if test "x$GPT_LOCATION" = "x"; then
      GPT_LOCATION=$DEFAULT_GPT_LOCATION
      if test ! -d $GPT_LOCATION; then
	GPT_LOCATION=$GLOBUS_LOCATION
      fi
      export GPT_LOCATION
    fi
  ]
)
AC_MSG_RESULT($GPT_LOCATION)
AC_SUBST(GPT_LOCATION)


AC_ARG_WITH(flavor,
  [  --with-flavor=<flavor>               Specify the globus build flavor. [[autodetect]]],
  [
    GLOBUS_FLAVOR_NAME=$withval
    if test ! -f "$GLOBUS_LOCATION/etc/globus_core/flavor_$GLOBUS_FLAVOR_NAME.gpt"; then
      echo "ERROR: Flavor $GLOBUS_FLAVOR_NAME has not been installed" >&2
      exit 1
    fi
  ],
  [
    if test "x$GLOBUS_FLAVOR_NAME" = "x"; then
      AC_CHECK_PROG(GLOBUS_FLAVOR_CONF, globus-flavor-configuration, $GLOBUS_LOCATION/sbin/globus-flavor-configuration, not found, $GLOBUS_LOCATION/sbin)
      if test "x$GLOBUS_FLAVOR_CONF" = "xnot found"; then
	AC_CHECK_PROG(GPT_FLAVOR_CONF, gpt-flavor-configuration, $GPT_LOCATION/sbin/gpt-flavor-configuration, not found, $GPT_LOCATION/sbin)
	if test "x$GPT_FLAVOR_CONF" = "xnot found"; then
	  AC_MSG_WARN([Please specify a globus build flavor])
          FLAVOR_CONF=
        else
	  FLAVOR_CONF=$GPT_FLAVOR_CONF
	fi
      else
	FLAVOR_CONF=$GLOBUS_FLAVOR_CONF
      fi
      if test "x$FLAVOR_CONF" = "x"; then
        GLOBUS_FLAVOR_NAME=
      else
        GLOBUS_FLAVOR_NAME=`$FLAVOR_CONF |grep '[[a-zA-Z0-9]]*:' |tr -d ':' |head -1`
      fi
    fi
  ]
)

AC_MSG_CHECKING(for Globus flavor)
AC_MSG_RESULT($GLOBUS_FLAVOR_NAME)
AC_SUBST(GLOBUS_FLAVOR_NAME)


GLOBUS_INCLUDES="-I$GLOBUS_LOCATION/include/$GLOBUS_FLAVOR_NAME -I$GLOBUS_LOCATION/include/$GLOBUS_FLAVOR_NAME/openssl -I/usr/kerberos/include"
AC_SUBST(GLOBUS_INCLUDES)

GLOBUS_LIBS="-L$GLOBUS_LOCATION/lib"
AC_SUBST(GLOBUS_LIBS)

LDFLAGS=$GLOBUS_LIBS

CPPFLAGS=$GLOBUS_INCLUDES

dnl
dnl DEFAULT_ARC_LOCATION
dnl

AC_MSG_CHECKING(for DEFAULT_ARC_LOCATION)
AC_ARG_WITH(default-arc-location,
  [  --with-default-arc-location=<PATH>  Specify the default arc location. [[/opt/nordugrid-arc]]],
  [
    DEFAULT_ARC_LOCATION="$withval"
  ],
  [
    DEFAULT_ARC_LOCATION="/opt/nordugrid-arc"
  ]
)
AC_MSG_RESULT($DEFAULT_ARC_LOCATION)
AC_DEFINE_UNQUOTED(DEFAULT_ARC_LOCATION,"$DEFAULT_ARC_LOCATION",[Default ARC installation path])
AC_SUBST(DEFAULT_ARC_LOCATION)

dnl
dnl ARC_LOCATION
dnl
AC_MSG_CHECKING(for ARC_LOCATION)
AC_ARG_WITH(arc-location,
  [  --with-arc-location=<PATH>        Specify the arc installation path. [[/opt/nordugrid-arc]]],
  [
    ARC_LOCATION="$withval"
    export ARC_LOCATION
  ],
  [
    if test "x$ARC_LOCATION" = "x"; then
      ARC_LOCATION=$DEFAULT_ARC_LOCATION
      export ARC_LOCATION
    fi
  ]
)
if test -d $ARC_LOCATION; then
  AC_MSG_RESULT($ARC_LOCATION)
  if test "$LD_LIBRARY_PATH" = ""
    export LD_LIBRARY_PATH="$ARC_LOCATION/lib"
  then
    export LD_LIBRARY_PATH="$ARC_LOCATION/lib:$LD_LIBRARY_PATH"
  fi
else
  AC_MSG_RESULT(not found)
  AC_MSG_WARN(No nordugrid arc found.  Build should fail)
  ARC_LOCATION=
fi
AC_SUBST(ARC_LOCATION)

dnl
dnl ARC includes
dnl

ARC_INCLUDES=" -I$ARC_LOCATION/include/"

ARC_LIBS=" -L$ARC_LOCATION/lib"
AC_SUBST(ARC_LIBS)
LDFLAGS+=$ARC_LIBS

AC_SUBST(ARC_INCLUDES)

CPPFLAGS+=$ARC_INCLUDES

]
)
