/* $Id$ */
/* start[./copyright.txt] */
/* stop[./copyright.txt] */

#include "common.h"

/**
 * Return the current local time and timezone as a string.  Returned
 * string value has to be free()'d
 */
char *getLTStr()
{
    // Initialize to zero
    time_t t = 0;

    // Get current time
    time( &t );

    // Initialize local timezone
    tzset();

    // Build a sufficiently large buffer to hold the value
    char *obuf = (char *)malloc( strlen( tzname[1] ) + 1 + 26 );
    strcpy( obuf, tzname[1] );
    obuf[strlen( tzname[1] )] = ' ';

    ctime_r( &t, obuf + strlen( tzname[1] ) + 1 );

    // Remove trailing newline
    for ( int i = strlen( tzname[1] ) + 1; i < strlen( tzname[1] ) + 27 ; i++ ) {
        if ( obuf[i] == '\n' ) {
            obuf[i] = '\0';
            break;
        }
    }

    return obuf;
}


