/* $Id: event.h,v 1.1 2007-08-22 15:22:00 aehyvari Exp $ */
/* start[./copyright.txt] */
/* stop[./copyright.txt] */

/**
 * successfull - First submission ran until the successfull finished
 *               state
 * resubmit    - After at least one failed submission, the submission
 *               ran untill the successfull finished state
 * failed      - Resubmission count was surpassed and the job was
 *              abandonned
 * submitfail  - Job submission failed (crowded grid or so)
 */
enum event_t {
    successfull,
    resubmit,
    failed,
    submitfail,
    undef
};

class EvType {
    public:
        EvType() : start(0), stop(0), name("uninit"), type(undef),
                   resubmitted(false) {};
        int start;
        int stop;
        string name; // The name of the job causing event
        event_t type; // Type of the event
        string typeStr();
        bool isresubmitted();
        bool resubmitted;
};


