#include "struct.h"
#include <stdlib.h>
#include <stdio.h>

int main(int argc, char **argv)
{
    if (argc != 3) {
        printf("Usage: %s lists length\n", argv[0]);
        return 1;
    }

    int lists = atoi(argv[1]);
    int length = atoi(argv[2]);

    // Initialize an empty list of lists
    struct strllist* llist = (struct strllist*) \
                             malloc(sizeof(struct strllist));

    llist->first = llist->last = 0;

    int i;
    // Construct a list of lists
    for (i = 0; i < lists; i++) {
        // Construct a list of required size
        struct strlist* list = (struct strlist*) \
                               malloc(sizeof(struct strlist));
        list->first = list->last = 0;
        int j;
        for (j=0; j < length; j++) {
            char *name = (char*) malloc(MAX_NAME_LEN);
            snprintf(name, MAX_NAME_LEN, "foo-%d", j);
            struct strlistel* l = (struct strlistel*) \
                                  malloc(sizeof(struct strlistel));
            l->next = 0;
            l->name = name;

            if (list->first == 0)
                list->first = l;
            if (list->last != 0)
                list->last->next = l;
            list->last = l;
        }

        // Construct a llistel
        struct strllistel* llistel = (struct strllistel*) \
                                     malloc(sizeof(struct strllistel));
        llistel->next = 0;
        llistel->name = list;

        // Insert the empty list to llist
        if (llist->first == 0)
            llist->first = llistel;
        if (llist->last != 0)
            llist->last->next = llistel;
        llist->last = llistel;
    }

    struct strllistel* it;
    struct strlistel* it2;
    for (it = llist->first; it != 0; it = it->next) {
        printf("list\n");
        for (it2 = it->name->first; it2 != 0; it2 = it2->next) {
            printf("  %s\n", it2->name);
        }
    }
    return 0;
}
