%option noyywrap

%{
#include "inslangutil.h"
#include "inslang.h"
    extern char *parse_buffer; // Forward declaration here for YY_INPUT
//    char *getName(char *text);
    YY_BUFFER_STATE current_buffer = NULL;
# define YY_INPUT(buf, result, max_size) \
    { \
    current_buffer = yy_scan_string(parse_buffer); \
    }
%}

%%

"("     {
    return LEFT;
}

")"     {
    return RIGHT;
}

"timescale"     {
    return TIMESCALE;
}

"evtypes"  {
    return EVTYPES;
}

"thnames"     {
    return THNAMES;
}

"jobnames"  {
    return JOBNAMES;
}

"runtimes" {
    return RUNTIMES;
}

"events" {
    return EVENTS;
}

"simeventsc" {
    return SIMEVENTSC;
}


[\n\t ]+   /* Eat up whitespaces (don't want to print them) */



[0-9][0-9]*\.[0-9][0-9]* {

    /* A float (returned as a string) */

    struct t_str *str = (struct t_str*) malloc(sizeof(struct t_str));
    str->contents = (char *)malloc(yyleng + 1);
    strncpy(str->contents, yytext, yyleng);
    str->contents[yyleng] = '\0';
    yylval.val = str;
    return FLOAT;
}

\[[^]]*\] {
    /* Names are indentified by surrounding angle brackets */
    struct t_str *str = (struct t_str*) malloc(sizeof(struct t_str));
    str->contents = (char *)malloc(yyleng + 1);
    strncpy(str->contents, yytext, yyleng);
    str->contents[yyleng] = '\0';
    yylval.val = str;
    return NAME;
}

[a-zA-Z_][a-zA-Z0-9_]* {
    /* types are other strings, containing some standard var-name chars */
    struct t_str *str = (struct t_str*) malloc(sizeof(struct t_str));
    str->contents = (char *)malloc(yyleng + 1);
    strncpy(str->contents, yytext, yyleng);
    str->contents[yyleng] = '\0';
    yylval.val = str;
    return TYPE;
}

%%

/*
char *getName(char *text) {
    int i, j;

    char *str = (char *)malloc(strlen(text)); // Overapprox...
    // Search for the start of the [...]
    for (i=0; i < strlen(text) && text[i] != '['; i++);

    // Copy everything, including [ and ]
    for (j=0; i < strlen(text) && text[i] != ']'; i++, j++) {
        str[j] = text[i];
    }
    str[j] = ']';
    str[j+1] = '\0';
    return (char*) realloc(str, j+2);
}
*/

//int yywrap()
//{
////    yy_flush_buffer(yy_buffer_stack[(yy_buffer_stack_top)]);
////    yy_init = 1;  // Need to reinitialize the solving. This is a kludge
//                  // thing, but I really don't know how to do it
//                  // properly.
//    yy_flush_buffer;
//    yyrestart(NULL);
//    return 1;
//}
