
%{
#define YYERROR_VERBOSE

extern int yylex(); // Needed by c++
//extern void* malloc(size_t);
//extern int yyerror(void* scanner); // Ditto
# include <stdio.h>
# include "inslangutil.h"
# include "parsebuffer.h"

static struct Node *p;    // Gather here the problem. Current implementation
                          // supports only one problem.
//struct strlist* t_lines;  // temp list of additional lines

//struct timescale* ts_tmp; // A temporary for the timescale
//struct simeventsc* se_tmp; // A temporary for the simeventsc

struct Node *addNode(struct NodeList *nl) {
    struct Node *tmp = \
        (struct Node*) malloc(sizeof(struct Node));

    tmp->type           = NULL;
    tmp->children       = NULL;
    tmp->value          = NULL;
    tmp->next           = NULL;

    if ( nl->first == NULL ) {
        nl->first = tmp;
        nl->last  = tmp;
    }

    else {
        nl->last->next = tmp;
        nl->last = tmp;
    }

    return tmp;
}

%}

%start ROOT

%union {
    struct t_str        *val;  /* For returning strings */
    double               num;  /* For numbers */
    struct Node         *nod;  /* For nodes */
    struct NodeList     *lis;  /* For list of nodes */
}

%token          LEFT            "("
%token          RIGHT           ")"
%token          TIMESCALE
%token          EVTYPES
%token          THNAMES
%token          JOBNAMES
%token          RUNTIMES
%token          EVENTS
%token          SIMEVENTSC
%token <val>    FLOAT
%token <val>    NAME
%token <val>    TYPE

%type  <nod>    tree
%type  <lis>    body timescale_t evtypes_t interval jobnames_t thnames_t
                runtimes_t events_t simeventsc_t eventlist event

%%

ROOT:
//     {
//        // Initialize the problem
//        p =     (struct problem*) malloc(sizeof(struct problem));
//        p->ts = NULL; // (struct strlist*) malloc(sizeof(struct timescale));
//        p->se = (struct simeventsc_l*) malloc(sizeof(struct simeventsc_l));
//     }
     {
        /* empty */
        p = (struct Node *) malloc(sizeof(struct Node));
        p->type = (char *)malloc(sizeof("empty"));
        strcpy(p->type, "empty");

        p->children = NULL;

        p->value = NULL;

        p->next = NULL;
    }
  |
    tree { p = $1; }
;

tree:
    "(" body ")" {
        struct Node *node = \
            (struct Node*) malloc(sizeof(struct Node));
        node->type      = (char*)malloc(sizeof("root"));
        strcpy(node->type, "root");
        node->children  = $2;
        node->value     = NULL;
        node->next      = NULL;
        $$ = node;
    }
;

body:
    {
        struct NodeList *empty = \
            (struct NodeList*) malloc(sizeof(struct NodeList));
        empty->first = NULL;
        empty->last  = NULL;
        $$ = empty;
    }
  |
    body
    "(" timescale_t ")" {
        /* Construct a new element to the list */
        struct Node *tmp = addNode($1);
        tmp->type       = (char*)malloc(sizeof("timescale_t"));
        strcpy(tmp->type, "timescale_t");
        tmp->children   = $3;
        tmp->value      = NULL;
        tmp->next       = NULL;

        $$ = $1;
    }
  |
    body
    "(" evtypes_t   ")" {
        /* Construct a new element to the list */

        struct Node *tmp = addNode($1);
        tmp->type       = (char*)malloc(sizeof("evtypes_t"));
        strcpy(tmp->type, "evtypes_t");
        tmp->children   = $3;
        tmp->value      = NULL;
        tmp->next = NULL;

        $$ = $1;
    }
  |
    body        "(" jobnames_t  ")" {
        struct Node *tmp = addNode($1);

        /* Construct a new element to the list */
        tmp->type       = (char*)malloc(sizeof("jobnames_t"));
        strcpy(tmp->type, "jobnames_t");
        tmp->children   = $3;
        tmp->value      = NULL;
        tmp->next = NULL;

        $$ = $1;
    }
  |
    body        "(" thnames_t ")" {
        struct Node *tmp = addNode($1);

        tmp->type       = (char*)malloc(sizeof("thnames_t"));
        strcpy(tmp->type, "thnames_t");
        tmp->children   = $3;
        tmp->value      = NULL;
        tmp->next       = NULL;
        $$ = $1;
    }
  |
    body        "(" runtimes_t  ")" {
        struct Node *tmp = addNode($1);
        tmp->type       = (char*)malloc(sizeof("runtimes_t"));
        strcpy(tmp->type, "runtimes_t");
        tmp->children   = $3;
        tmp->value      = NULL;
        tmp->next       = NULL;
        $$ = $1;
    }
  |
    body        "(" events_t    ")" {
        struct Node *tmp = addNode($1);
        tmp->type       = (char*)malloc(sizeof("events_t"));
        strcpy(tmp->type, "events_t");
        tmp->children   = $3;
        tmp->value      = NULL;
        tmp->next       = NULL;
        $$ = $1;
    }
  |
    body        "(" simeventsc_t ")" {
        struct Node *tmp = addNode($1);
        tmp->type       = (char*)malloc(sizeof("simevents_t"));
        strcpy(tmp->type, "simevents_t");
        tmp->children   = $3;
        tmp->value      = NULL;
        tmp->next       = NULL;
        $$ = $1;
    }
;

interval:
    "(" FLOAT FLOAT ")"
    {
        struct NodeList *ts_tmp = \
            (struct NodeList*)malloc(sizeof(struct NodeList));
        struct Node *first = \
            (struct Node*)malloc(sizeof(struct Node));
        struct Node *second = \
            (struct Node*)malloc(sizeof(struct Node));

        first->type     = (char *)malloc(sizeof("double"));
        strcpy(first->type, "double");
        first->children = NULL;
        first->value    = $2->contents;
        free($2);
        first->next     = second;

        second->type     = (char *)malloc(sizeof("double"));
        strcpy(second->type, "double");
        second->children = NULL;
        second->value    = $3->contents;
        free($3);
        second->next     = NULL;

        ts_tmp->first    = first;
        ts_tmp->last     = second;

        $$ = ts_tmp;
    }
;

timescale_t:
    TIMESCALE
    interval
    {
//        struct NodeList* ts = \
//            (struct NodeList *)malloc(sizeof(struct NodeList));
//
        $$ = $2;
    }
;

/* not implemented */
evtypes_t:
    EVTYPES LEFT RIGHT {
        struct NodeList *nl = \
            (struct NodeList*) malloc(sizeof(struct NodeList));
        nl->first = nl->last = NULL;
        $$ = nl;
    }
;

/* not implemented */
thnames_t:
    THNAMES LEFT RIGHT {
        struct NodeList *nl = \
            (struct NodeList*) malloc(sizeof(struct NodeList));
        nl->first = nl->last = NULL;
        $$ = nl;
    }
;

/* not implemented */
jobnames_t:
    JOBNAMES LEFT RIGHT {
        struct NodeList *nl = \
            (struct NodeList*) malloc(sizeof(struct NodeList));
        nl->first = nl->last = NULL;
        $$ = nl;
    }
;

/* not implemented */
runtimes_t:
    RUNTIMES LEFT RIGHT {
        struct NodeList *nl = \
            (struct NodeList*) malloc(sizeof(struct NodeList));
        nl->first = nl->last = NULL;
        $$ = nl;
    }

;

/* not implemented */
events_t:
    EVENTS LEFT RIGHT {
        struct NodeList *nl = \
            (struct NodeList*) malloc(sizeof(struct NodeList));
        nl->first = nl->last = NULL;
        $$ = nl;
    }
;

simeventsc_t:
    SIMEVENTSC LEFT eventlist RIGHT {
        $$ = $3;
    }
;

eventlist:
    {
        struct NodeList *empty = \
            (struct NodeList*) malloc(sizeof(struct NodeList));
        empty->first = NULL;
        empty->last  = NULL;
        $$ = empty;
    }
  |
    eventlist
    event {
        /* Construct a new element to the list */

        struct Node *tmp = addNode($1);
        tmp->type       = (char*)malloc(sizeof("evtypes_t"));
        strcpy(tmp->type, "evtypes_t");
        tmp->children   = $2;
        tmp->value      = NULL;
        tmp->next       = NULL;

        $$              = $1;
    }

;

event:
    "("
    NAME
    interval
    TYPE
    ")"
    {
        struct NodeList *eventlist = \
            (struct NodeList*) malloc(sizeof(struct NodeList));
        eventlist->first = NULL;
        eventlist->last  = NULL;

        struct Node *name       = addNode(eventlist);
        struct Node *interv     = addNode(eventlist);
        struct Node *status     = addNode(eventlist);

        name->type      = (char*)malloc(sizeof("name"));
        strcpy(name->type, "name");
        name->children  = NULL;
        name->value     = $2->contents;
        free($2);
        name->next      = interv;

        interv->type    = (char*)malloc(sizeof("interval"));
        strcpy(interv->type, "interval");
        interv->children= $3;
        interv->value   = NULL;
        interv->next    = status;

        status->type    = (char*)malloc(sizeof("status"));
        strcpy(status->type, "status");
        status->children= NULL;
        status->value   = $4->contents;
        free($4);
        status->next    = NULL;

        $$ = eventlist;
    }

;

%%

#include "inslang.h"

int yyerror(char *s) {
    printf("%s\n", s);
}

// A wrapper for parsing a given string
struct Node* parsestring(char *str)
{
    parse_buffer = str;
    int retval = yyparse();
    yyrestart(NULL);
//    yy_delete_buffer(parse_buffer);
    if (retval == 0)
        return p;
    else
        return 0;
}

void printTree(struct Node *n, int indent) {

    int i;
    for (i = 0; i < indent; i++)
        printf(" ");

    printf("%s, %s\n", n->type, n->value);

    if (n->children != NULL) {
        struct Node *first;
        for (first = n->children->first;
                first != NULL;
                first = first->next) {
            printTree(first, indent + 1);
        }
    }
    return;
}

void freeTree(struct Node *n) {

    if (n->children != NULL) {
        struct Node *first;
        for (first = n->children->first;
                first != NULL;) {
            struct Node *next = first->next;
            freeTree(first);
            first = next;
        }

        free(n->children);

    }

    if (n->type  != NULL) free(n->type);
    if (n->value != NULL) free(n->value);
    free(n);

}

