AC_DEFUN([GRIDJM_INIT],
[
dnl
dnl gSOAP
dnl
gsoap=yes
https_init_script=""
AC_ARG_WITH(gsoap-location,
  [  --with-gsoap-location=<PATH>         Specify the gSOAP installation path. [[autodetect]]],
  [ AC_PATH_PROG(soapcpp2, soapcpp2, not found, $with_gsoap_location/bin) ],
  [ AC_PATH_PROG(soapcpp2, soapcpp2, not found) ]
)
if test "x$soapcpp2" = "xnot found"; then
  gsoap_location=""
  gsoap=
  SOAPCPP2=:
  WSDL2H=:
else
  gsoap_location=`echo "$soapcpp2" | sed -e 's%/bin/soapcpp2$%%' -e 't' -e 's%.*%%'`
  SOAPCPP2=$gsoap_location/bin/soapcpp2
  WSDL2H=$gsoap_location/bin/wsdl2h
  if test "x$gsoap_location" = "x/usr"; then
    :
  else
    GSOAP_INCLUDES=-I$gsoap_location/include
    AC_SUBST(GSOAP_INCLUDES)
  fi
dnl
dnl Find gSoap library
dnl Ps: we should really use pkgconfig: PKG_CHECK_MODULES(GSOAP, gsoap++ >= 2.7.2)
dnl
  for lib in lib64 lib
  do
    if test -f "$gsoap_location/$lib/libgsoap++.la"
    then
      GSOAP_LIBS="-L$gsoap_location/$lib -lgsoap++"
      break
    fi
    if test -f "$gsoap_location/$lib/libgsoap++.a"
    then
      GSOAP_LIBS="-L$gsoap_location/$lib -lgsoap++"
      break
    fi
    if test -f "$gsoap_location/$lib/libgsoap++.so"
    then
      GSOAP_LIBS="-L$gsoap_location/$lib -lgsoap++"
      break
    fi
  done
  if test x"$GSOAP_LIBS" = x ; then
    AC_MSG_WARN([No gSOAP library found. Please install gSOAP.])
    gsoap=
  fi
  https_init_script=httpsd

dnl
dnl gSOAP version
dnl
AC_MSG_CHECKING(for gSOAP version)
gsoap_version=`$gsoap_location/bin/soapcpp2 -v 2>&1 | sed -e 's/.*version \([[^ ]]*\).*/\1/' -e 't new' -e 's/^.*Compiler for C and C++ *\([[^ ]]*\).*/\1/' -e 't matched' -e 's/.*//' -e ':matched' -e ':new' | grep '.'`
if test "x$gsoap_version" = "x"; then
  AC_MSG_WARN([Could not determine version.])
  gsoap=
fi
gsoap_version_major=`echo "$gsoap_version" | sed -e 's/^\([[^\.]]\).*/\1/' -e 't match' -e 's/.*/0/' -e ':match'`
gsoap_version_minor=`echo "$gsoap_version" | sed -e 's/^[[^\.]]*\.\([[^\.]]*\).*/\1/' -e 't match' -e 's/.*/0/' -e ':match'`
gsoap_version_subminor=`echo "$gsoap_version" | sed -e 's/^[[^\.]]*\.[[^\.]]*\.\([[0-9]]*\).*/\1/' -e 't match' -e 's/.*/0/' -e ':match'`
OLD_GSOAP=
AC_MSG_RESULT($gsoap_version_major.$gsoap_version_minor.$gsoap_version_subminor)
if test "$gsoap_version_major" -lt "2"; then
  AC_MSG_WARN([found gSOAP version $gsoap_version_major.$gsoap_version_minor.$gsoap_version_subminor - gSOAP with version below 2.7.2 is not supported anymore])
  gsoap=
fi
if test "$gsoap_version_major" -eq "2"; then
  if test "$gsoap_version_minor" -lt "7" ; then
    AC_MSG_WARN([found gSOAP version $gsoap_version_major.$gsoap_version_minor.$gsoap_version_subminor - gSOAP with version below 2.7.2 is not supported anymore])
    gsoap=
  fi
  if test "$gsoap_version_minor" -eq "7" && test "$gsoap_version_subminor" -lt "2" ; then
    AC_MSG_WARN([found gSOAP version $gsoap_version_major.$gsoap_version_minor.$gsoap_version_subminor - gSOAP with version below 2.7.2 is not supported anymore])
    gsoap=
  fi
fi

fi

if test "$gsoap" == "yes"; then
  :
else
  AC_MSG_WARN([gSoap not found - many things will not be built])
fi

AC_SUBST(GSOAP_LIBS)
AC_SUBST(GSOAP_LOCATION,$gsoap_location)
AM_CONDITIONAL(HAVE_GSOAP, test "x$gsoap" = "xyes")

]
)
