#include <stdio.h>
#include <string>
#include <iostream>
#include <getopt.h>
#include "version.h"

using namespace std;

char *optargs = "asd:f:";
int optind, opterr, optopt;

char * usage_string = "Gridjm usage:\n\
  --useuds, -u               Use uds for communication\n\
  --port <arg>, -p <arg>     Use tcp port number given as argument\n\
  --maxjobs <arg>, -m <arg>  Maximum number of jobs to send\n\
  --ngget <arg>, -n <arg>    Use ngget program given as argument\n\
                             (default is ngget)\n\
  --dir <arg>, -d <arg>      Use the download directory given as argument\n\
                             (default is /tmp/ngdownload)\n\
  --help, -h                 This help text\n";

struct arguments parseargs(int argc, char **argv) {
    int c;
    int digit_optind = 0;

    struct arguments args;

    // Default values
    args.useuds = false;
    args.port = 12345;
    args.maxjobs = 64;
    args.ngget = "ngget";
    args.dir = "/tmp/ngdownload";

    while (1) {
        int this_option_optind = (optind ? optind : 1);
        int option_index = 0;
        static struct option long_options[] = {
            {"useuds", 0, 0, 'u'},
            {"port", 1, 0, 'p'},
            {"maxjobs", 1, 0, 'm'},
            {"ngget", 1, 0, 'n'},
            {"dir", 1, 0, 'd'},
            {"help", 0, 0, 'h'},
            {0, 0, 0, 0}
        };

        c = getopt_long(argc, argv, "hup:m:n:d:",
                long_options, &option_index);
        if (c == -1)
            break;

        switch (c) {
            case 0:
                cout << "Option " << long_options[option_index].name;
                if (optarg)
                    cout << " with arg " << optarg;
                cout << endl;
                break;

            case 'h':
                cout << version_string << endl;
                cout << usage_string;
                break;

            case 'u':
                cout << "Option u" << endl;
                args.useuds = true;
                break;

            case 'p':
                cout << "Option p with arg " << optarg << endl;
                args.port = atoi(optarg);
                break;

            case 'm':
                cout << "Option m with arg " << optarg << endl;
                args.maxjobs = atoi(optarg);
                break;

            case 'n':
                cout << "Option n with arg " << optarg << endl;
                args.ngget = optarg;
                break;

            case 'd':
                cout << "Option d with arg " << optarg << endl;
                args.dir = optarg;
                break;

            case '?':
                cout << "Unknown option" << endl;
                break;

            case ':':
                cout << "Option requires an argument" << endl;
                break;

            default:
                cout << "Getopt returned strange value " << endl;
        }
    }

    return args;
}
