# $Id: keyquicksort.py,v 1.1 2007/02/05 17:34:25 aehyvari Exp $
### start[./copyright-py.txt]
# Including data from file ./copyright-py.txt
# file opened
# Reading 755 bytes of data
# Start of include
#
# Copyright 2007 Antti Hyvrinen
#
# This file is part of GridJM.
#
# GridJM is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# GridJM is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with GridJM; if not, write to the Free Software Foundation,
# Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#

# End of include
### stop[./copyright-py.txt]

def partition(table, low, high, key):
    pivot_item = table[low]
    left = low
    pivot = left
    right = high
    while (left < right):
        while left < len(table) and (table[left][key] <= pivot_item[key]):
            left += 1

        while (table[right][key] > pivot_item[key]):
            right -= 1
        if (left < right): # Swap
            tmp = table[left]
            table[left] = table[right]
            table[right] = tmp
    table[low] = table[right]
    table[right] = pivot_item
    return right

def quicksort(table, low, high, key):
    pivot = 0
    if (high > low):
        pivot = partition(table, low, high, key)
        quicksort(table, low, pivot - 1, key)
        quicksort(table, pivot + 1, high, key)


def sortbykey(table, key):
    quicksort(table, 0, len(table) - 1, key)

