#!/usr/bin/env python
#
# $Id: inssem.py,v 1.1 2007/02/05 17:34:24 aehyvari Exp $#
#
### start[copyright-py.txt]
# Including data from file copyright-py.txt
# file opened
# Reading 755 bytes of data
# Start of include
#
# Copyright 2007 Antti Hyvrinen
#
# This file is part of GridJM.
#
# GridJM is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# GridJM is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with GridJM; if not, write to the Free Software Foundation,
# Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#

# End of include
### stop[copyright-py.txt]

import inslang
import sys

class Event:
    def __init__(self, event, threadname):
        self.type = event[0]
        self.name = event[1][0]
        self.start = event[1][1]
        self.stop = event[1][2]
        self.threadname = threadname

    def __str__(self):
        return "threadname: " + self.threadname + \
            "\ntype: " + self.type + \
            "\nname: " + self.name + \
            "\nstart: " + str(self.start) + \
            "\nstop: " + str(self.stop)

    def duration(self):
        return self.stop - self.start

class CEvent:
    def __init__(self, time, type):
        self.t0 = time[0]
        self.t1 = time[1]
        self.type = type

class Semantic:
    def __init__(self):
        self.timescale = []
        self.threads = {}
        self.events = {}
        self.jobs = {}
        self.runtimes = []
        self.simevents = {}
        self.simeventsc = {}

    def getsemantic(self, tree):
        for label in tree:
            if (label[0] == 'timescale'):
                self.timescale = label[1]

            elif (label[0] == 'evtypes'):
                for ev in label[1]:
                    self.events[ev] = []

            elif (label[0] == 'thnames'):
                for name in label[1]:
                    self.threads[name] = []

            elif (label[0] == 'jobnames'):
                for name in label[1]:
                    self.jobs[name] = []

            elif (label[0] == 'events'):
                for th in label[1]:
                    self.toevents(th)

            elif (label[0] == 'runtimes'):
                for pair in label[1]:
                    self.runtimes.append(pair[1])

            elif (label[0] == 'simevents'):
                for event in label[1]:
                    self.simevents[event[0]] = event[1]
            elif (label[0] == 'simeventsc'):
                for event in label[1]:
                    self.simeventsc[event[0]] = \
                        CEvent(event[1], event[2])
            else:
                print "Unknown label:", label[0]

    def toevents(self, threadevs):
        threadname = threadevs[0]
        for ev in threadevs[1]:
            evobj = Event(ev, threadname)
            # Append to thread events
            self.threads[threadname].append(evobj)
            # Append to event list
            self.events[evobj.type].append(evobj)
            # Append to job list
            self.jobs[evobj.name].append(evobj)

    def geteventtimes(self):
        """For every event type, print the average of time spent in it"""


        for evkey in self.events:
            s = 0
            for ev in self.events[evkey]:
                s += ev.duration()
            print evkey, s/len(self.events[evkey])

        s = 0

        for time in self.runtimes:
            s += float(time)
        if len(self.runtimes) > 0:
            print "avg runtime", s/len(self.runtimes)

    def geteventtime(self, evkey):
        """For the event type evkey, return the average time spent in it"""
        s = 0
        for ev in self.events[evkey]:
            s += ev.duration()
        return s/len(self.events[evkey])

    def getcumruntime(self):
        s = 0
        for time in self.runtimes:
            s += float(time)
        return s

if __name__ == '__main__':
    sem = Semantic()
    text = open(sys.argv[1], 'r').read()
    rv, P = inslang.parse('start', text)
    sem.getsemantic(P.tree)
    print "Timescale: " + str(sem.timescale[0]) + " - " + str(sem.timescale[1])
    print sem.events
    print sem.threads
    print sem.jobs
else:
    print "Parse by running " + __name__ + ".construct(filename)"

def construct(text):
    sem = Semantic()
    rv, P = inslang.parse('start', text)
    sem.getsemantic(P.tree)
    return sem

def construct1(file):
    text = open(file, 'r').read()
    return construct(text)

