/* $Id: instrumentation.h,v 1.2 2007-09-03 07:20:18 aehyvari Exp $ */
/* start[./copyright.txt] */
/* Including data from file ./copyright.txt */
/* file opened */
/* Reading 775 bytes of data */
/* Start of include */
/*
 * Copyright 2007 Antti Hyvrinen
 *
 * This file is part of GridJM.
 *
 * GridJM is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * GridJM is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GridJM; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/* End of include */
/* stop[./copyright.txt] */

#include <string>
#include <fstream>
#include <list>
#include <assert.h>
#include <unistd.h>
#include <time.h>
using namespace std;

/**
 * successfull - First submission ran until the successfull finished
 *               state
 * resubmit    - After at least one failed submission, the submission
 *               ran untill the successfull finished state
 * failed      - Resubmission count was surpassed and the job was
 *              abandonned
 * submitfail  - Job submission failed (crowded grid or so)
 */
enum event_t {
    successfull,
    resubmit,
    failed,
    submitfail,
    undef
};

class EvType {
    public:
        EvType() : start(0), stop(0), name("uninit"), type(undef),
                   resubmitted(false) {};
        int start;
        int stop;
        string name; // The name of the job causing event
        event_t type; // Type of the event
        string typeStr();
        bool isresubmitted();
        bool resubmitted;
};

class Instrumenter {
    public:
        Instrumenter(string filename);
        ~Instrumenter();
        void simstart(string evname);
        void simstop(string evname, event_t type);
        void tofile();
        /* A change in event, such as the event was resubmitted */
        bool evchange(string evname, event_t type);
        list<EvType*> simevents;
    private:
        string filename;
        ofstream output; // Output filename's file descriptor
        int firstentry;
        int lastentry;
        int GetTime();
};
