/* $Id: foo3.cpp,v 1.2 2007-09-03 07:20:37 aehyvari Exp $ */
/* start[./copyright.txt] */
/* stop[./copyright.txt] */

#include "SDL/SDL.h"
#include <string>

#include "../instrumentation.h"

const int SCREEN_WIDTH   = 640;
const int SCREEN_HEIGHT  = 480;
const int SCREEN_BPP     = 32;

SDL_Surface *message     = NULL;
SDL_Surface *background  = NULL;
SDL_Surface *screen      = NULL;

SDL_Surface *load_image( std::string filename )
{
    SDL_Surface *loadedImage = NULL;
    SDL_Surface *optimizedImage = NULL;

    loadedImage = SDL_LoadBMP( filename.c_str() );

    if ( loadedImage != NULL)
    {
        optimizedImage = SDL_DisplayFormat( loadedImage );
        SDL_FreeSurface( loadedImage );
    }

    return optimizedImage;
}

void apply_surface( int x, int y, SDL_Surface *source, SDL_Surface *destination )
{
    SDL_Rect offset;

    offset.x = x;
    offset.y = y;

    SDL_BlitSurface( source, NULL, destination, &offset );
}

void DrawRect( SDL_Surface *screen,
               Sint32 x1, Sint32 y1,
               Sint32 x2, Sint32 y2,
               Uint8 R, Uint8 G, Uint8 B,
               bool filled )
{
    Uint32 color = SDL_MapRGB( screen->format, R, G, B );
    if ( SDL_MUSTLOCK(screen) ){
        if ( SDL_LockSurface(screen) < 0 ) {
            return;
        }
    }

    Uint32 *bufp;

    // Top hozirontal
    for ( Sint32 x = x1; x <= x2; x++ )
    {
        bufp = (Uint32 *)screen->pixels + y1*screen->pitch/4 + x;
        *bufp = color;
    }

    // Bottom horizontal
    for ( Sint32 x = x1; x <= x2; x++ )
    {
        bufp = (Uint32 *)screen->pixels + y2*screen->pitch/4 + x;
        *bufp = color;
    }

    // Left vertical
    for ( Sint32 y = y1; y <= y2; y++ )
    {
        bufp = (Uint32 *)screen->pixels + y*screen->pitch/4 + x1;
        *bufp = color;
    }

    // Right vertical
    for ( Sint32 y = y1; y <= y2; y++ )
    {
        bufp = (Uint32 *)screen->pixels + y*screen->pitch/4 + x2;
        *bufp = color;
    }

    // If requested to fill, draw the inside as well
    if ( filled )
    {
        for ( Sint32 x = x1+1; x < x2; x++ )
        {
            for ( Sint32 y = y1 + 1; y < y2; y++ )
            {
                bufp = (Uint32 *)screen->pixels + y*screen->pitch/4 + x;
//                Uint8 Rp, Gp, Bp;
//                SDL_GetRGB(*bufp, screen->format, &Rp, &Gp, &Bp);
//                color = SDL_MapRGB(screen->format, (R+Rp)<<2, (G+Gp)<<2, (B+Bp)<<2);
                *bufp = color;
            }
        }
    }

    if ( SDL_MUSTLOCK( screen ) )
        SDL_UnlockSurface(screen);

//    SDL_UpdateRect(screen, x, y, 1, 1);
}

int main ( int argc, char **args )
{
    if ( SDL_Init( SDL_INIT_EVERYTHING )  == -1 )
        return 1;

    screen = SDL_SetVideoMode( SCREEN_WIDTH, SCREEN_HEIGHT, SCREEN_BPP, SDL_SWSURFACE );

    if ( screen == NULL )
        return 1;

    SDL_WM_SetCaption( "GridJM Visualize", "GridJM Visualize" );

    message = load_image( "hello_world.bmp" );
    background = load_image( "background.bmp" );
    apply_surface( 0, 0, background, screen );

    apply_surface( 180, 140, message, screen );

    if ( SDL_Flip( screen ) == -1 )
        return 1;

    Instrumenter *inst = new Instrumenter("/tmp/foo.ins");
    inst->simstart("foo1");
    sleep(1);
    inst->simstart("foo2");
    sleep(2);
    inst->simstop("foo2", resubmit);
    sleep(1);
    inst->simstop("foo1", failed);
    
    for (list<EvType*>::iterator evt = inst->simevents.begin();
            evt != inst->simevents.end();
            evt++)
    {
        printf("%s: %d %d\n", (*evt)->name.c_str(), (*evt)->start, (*evt));
    }

    DrawRect( screen, 150, 150, 250, 170, (Uint8) 255, 0, 0, true );
    DrawRect( screen, 170, 150, 230, 170, 128, 128, 128, true );
    DrawRect( screen, 150, 150, 250, 170, 0, 0, 0, false );
    if ( SDL_Flip( screen ) == -1 )
        return 1;

    SDL_Delay( 2000 );
    SDL_FreeSurface( message );
    SDL_FreeSurface( background );

    SDL_Quit();

    return 0;
}
