#!/usr/bin/env python
# $Id: griddlparser.py,v 1.1 2007/02/05 17:34:24 aehyvari Exp $
### start[./copyright-py.txt]
# Including data from file ./copyright-py.txt
# file opened
# Reading 755 bytes of data
# Start of include
#
# Copyright 2007 Antti Hyvrinen
#
# This file is part of GridJM.
#
# GridJM is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# GridJM is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with GridJM; if not, write to the Free Software Foundation,
# Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#

# End of include
### stop[./copyright-py.txt]

import sys
import os.path
import re

numunknowns = 0

class NoOutputError(Exception):
    def __init__(self, dldir):
        self.dldir = dldir

    def __str__(self):
        return self.dldir

class Construct:
    def __init__(self, dldir):
        output = os.path.join(dldir, "satjob.out-pr")
        output2 = os.path.join(dldir, "satjob.out")
        output3 = os.path.join(dldir, "haxor.out-pr") # test
        cpuinfo = os.path.join(dldir, "cpuinfo")
        diag = os.path.join(dldir, "gridlog/diag")

        try:
            output = open(output).read()
        except IOError, e:
            try:
                output = open(output2).read()
            except IOError, e2:
                try:
                    output = open(output3).read()
                except IOError, e3:
                    print e # This is fatal
                    print e2
                    raise NoOutputError("No solver output in " + dldir)

        try:
            cpuinfo = open(cpuinfo).read()
        except IOError, e:
            cpuinfo = ""
            print e # This is ok

        try:
            diag = open(diag).read()
        except IOError, e:
            diag = ""
            print e # This is too

        # Now we have read the information. Then we need to parse it

#        mo = re.search("Total Run Time[ \t]*([0-9\.]*)$", output, re.M)
	mo = re.search("KernelTime=([0-9\.]*)", diag, re.M)
        if mo:
            self.runtime = float(mo.group(1))
        else:
            raise NoOutputError("No kernel run time in " + dldir)

	mo = re.search("UserTime=([0-9\.]*)", diag, re.M)
	if mo:
	    self.runtime += float(mo.group(1))
	else:
	    raise NoOutputError("No user run time in " + dldir)

        mo = re.search("^jobname = (.*)", output, re.M)
        if mo:
            self.jobname = mo.group(1)
        else:
            self.jobname = "['unknown', -1]"
#            self.jobname = "['unknown', " + numunknowns + "]"
#            numunknowns += 1

if __name__ == '__main__':
    if len(sys.argv) != 2:
        print "Usage:", sys.argv[0], "dldir"
        sys.exit(1)
    else:
        Construct(sys.argv[1])

else:
    print "Parse by running", __name__ + ".Construct(dldir)"
