/* $Id: parseargs.cpp,v 1.3 2007/02/05 18:16:39 aehyvari Exp $ */
/* start[copyright.txt] */
/* Including data from file copyright.txt */
/* file opened */
/* Reading 775 bytes of data */
/* Start of include */
/*
 * Copyright 2007 Antti Hyvrinen
 *
 * This file is part of GridJM.
 *
 * GridJM is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * GridJM is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GridJM; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/* End of include */
/* stop[copyright.txt] */

#include <stdio.h>
#include <string>
#include <iostream>
#include <getopt.h>
#include "parseargs.h"
#include "version.h"

using namespace std;

char *optargs = "d:hi:j:m:n:p:q:r:t:u:";

int optind, opterr, optopt;

char * usage_string = "Gridjm usage:\n\
  --cluster-update int,      Cluster update interval (seconds)\n\
    -c int                    (default is 3600) \n\
  --dir str, -d str          Use the download directory given as argument\n\
                              (default is /tmp/ngdownload/)\n\
  --help, -h                 This help text\n\
  --instrumentation str,     Instrumentation file (default /tmp/gridjm.ins)\n\
    -i str                   \n\
  --jobstall int, -j int     Job state stall timeout (seconds)\n\
                              (default 600)\n\
  --maxjobs int, -m int      Maximum number of simultaneous jobs requested\n\
  --ngget str, -n str        Use ngget program given as argument\n\
                              (default is ngget)\n\
  --port int, -p int         Use tcp port number given as argument\n\
  --queue-update int, -q int Queue update period (seconds) (default is 300)\n\
  --pidfile str, -r str      Pid file name (default /tmp/gridjm.pid)\n\
  --interval int, -t int     Update interval for jobs in grid (seconds)\n\
  --useuds str, -u str       Use uds for communication\n\
                              (default is not to use)\n";

void parseargs(int argc, char **argv, struct arguments *args) {
    int c;
    int digit_optind = 0;

    // Default values
    args->error = false;
    args->useuds = false;
    args->socketstring = "";
    args->port = 12345;
    args->maxjobs = 64;
    args->ngget = "ngget";
    args->dir = "/tmp/ngdownload";
    args->pidfile = "/tmp/gridjm.pid";
    args->instrumentation = "/tmp/gridjm.ins";
    args->interval = 30;
    args->clupdp = 3600;
    args->qupdp = 300;
    args->s_timeout = 600;

    while (1) {
        int this_option_optind = (optind ? optind : 1);
        int option_index = 0;
        static struct option long_options[] = {
            {"cluster-update", 1, 0, 'c'},
            {"dir", 1, 0, 'd'},
            {"help", 0, 0, 'h'},
            {"instrumentation", 1, 0, 'i'},
            {"jobstall", 1, 0, 'j'},
            {"maxjobs", 1, 0, 'm'},
            {"ngget", 1, 0, 'n'},
            {"port", 1, 0, 'p'},
            {"queue-update", 1, 0, 'q'},
            {"pidfile", 1, 0, 'r'},
            {"interval", 1, 0, 't'},
            {"useuds", 1, 0, 'u'},
            {0, 0, 0, 0}
        };

        c = getopt_long(argc, argv, optargs,
                long_options, &option_index);
        if (c == -1)
            break;

        switch (c) {
            case 0:
                cout << "Option " << long_options[option_index].name;
                if (optarg)
                    cout << " with arg " << optarg;
                cout << endl;
                args->error = true;
                break;

            case 'c':
                args->clupdp = atoi(optarg);
                break;

            case 'd':
                args->dir = optarg;
                break;

            case 'h':
                cout << version_string << endl;
                cout << usage_string;
                args->error = true;
                break;

            case 'i':
                args->instrumentation = optarg;
                break;

            case 'j':
                args->s_timeout = atoi(optarg);
                break;

            case 'm':
                args->maxjobs = atoi(optarg);
                break;

            case 'n':
                args->ngget = optarg;
                break;

            case 'p':
                cout << "Using port number " << optarg << endl;
                args->port = atoi(optarg);
                break;

            case 'q':
                args->qupdp = atoi(optarg);
                break;

            case 'r':
                args->pidfile = optarg;
                break;

            case 't':
                args->interval = atoi(optarg);
                break;

            case 'u':
                cout << "Using socket name " << optarg << endl;
                args->useuds = true;
                args->socketstring = optarg;
                break;

            case '?':
                cout << "Unknown option " << argv[1] << endl;
                args->error = true;
                break;

            case ':':
                cout << "Option requires an argument " << \
                    argv[1] << endl;
                args->error = true;
                break;

            default:
                cout << "Getopt returned strange value " << endl;
                args->error = true;
        }
    }
    return;
}
