/* $Id: gridjm.h,v 1.4 2007/02/05 10:29:37 aehyvari Exp $ */
/* start[copyright.txt] */
/* Including data from file copyright.txt */
/* file opened */
/* Reading 775 bytes of data */
/* Start of include */
/*
 * Copyright 2007 Antti Hyvrinen
 *
 * This file is part of GridJM.
 *
 * GridJM is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * GridJM is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GridJM; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/* End of include */
/* stop[copyright.txt] */

#define MAXSTATUSLENGTH 17      // Bad style...
#define RESUBMIT_ATTEMPTS 1
#define BAD_TIMEOUT 1200         // Bad cluster timeout (s)
#include <time.h>
#include <vector>
#include <queue>
#include <arc/xrsl.h>
#include <arc/url.h>
#include <arc/resource.h>
#include "instrumentation.h"
#include "common.h"

using namespace std;

class JobStatus {

    public:
        /**
         * Constructor - takes xrsl string and job id
         */
        JobStatus(Xrsl* xrsl, URL *jobid);

        /**
         * Destructer
         */
        ~JobStatus();

        /**
         * Returns the xrsl of the jobs
         */
        Xrsl* getXrsl();

        /**
         * Returns the job id of the job
         */
        URL *getJobid();

        /**
         * Returns the number resubmissions attempts
         */
        int getAttempts();

        /**
         * Returns the previous status of the job, which is one of
                 *
         * ACCEPTED CANCELING DELETED FINISHED FINISHING INLRMS NUM
                 * PREPARING SUBMITING UNDEFINED
         *
         * or something...
         */
        string getPrevStatus();

        /**
         * Returns the time (since the epoch, in seconds) the
         * status was last changed.
         */
        time_t getPrevTime();
        /**
         * Set new job status
         */
        void setNewStatus(string s);
        /**
         * Updates the object with new information about a submission
         * The old cluster is put into the cluster vector, the
         * current jobid is set to the new jobid and the number
         * of attempts is incremented by 1
         */
        void newSubmission(URL *new_jobid);
        /**
         * Return the name of the job, as provided in the xrsl
         */
        string getName();

    private:
        int attempts;              // Number of submission attempts
        URL *current_jobid;        // Current jobid
        Xrsl* xrsl;                // Xrsl string to create object from
        vector <string> clusters;  // List of the cluster the job has been on
        string prev_status;        // Current status of job
        time_t prev_time;          // The time the status of job last changed
};

class BCEntry {
    public:
        BCEntry(string cl, int to);
        bool valid();
        string cluster;
    private:
        int timeout;
        time_t insert_time;
};

class GridJM {
    public:
        GridJM(Instrumenter* i, struct arguments * a, int p_write,
                queue<char*> *n_jobs, pthread_mutex_t *n_jobs_lock,
                list<PidJob*> *f_downloads, pthread_mutex_t *f_dl_lock);
        ~GridJM() {};
        int start();
    private:
        int mainloop();
        void GetMoreJobs();
        struct arguments * args;
        int pipe_write;
        pthread_mutex_t *forked_dl_lock;
        int maxgridjobs;
        int update_interval;
        void UpdateJobStatus();
        void HandleNewJobs();
        URL *SubmitJob(Xrsl* xrsl);
        bool HandleJobFailure(string jobname);
        void FetchJob(string jobname);
        pthread_mutex_t *new_jobs_lock;
        bool running;
        list<PidJob*> *forked_downloads;
        queue<char*> *new_jobs;
        map<string, JobStatus*> current_jobs;
        int num_current_jobs;
        time_t clupd;   // Last time cluster list was updated
        list<URL> clusters;
        time_t qupd;   // Last time queue list was updated
        std::list<Queue> queuelist;
        Instrumenter* inst;        // The instrumentation
        vector<BCEntry*> badclusters; // Bad clusters
};

