#include <sys/select.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <unistd.h>
#include <signal.h>
#include <errno.h>
#include <pthread.h>

#define BUFSIZE 2
//#define READSIZE getsockopt(socket, SOL_SOCKET, SO_RCVBUF...)
#define READSIZE 1024

struct pidlist {
    pid_t p;
    struct pidlist* next;
};

int child_events = 0;

/* Pointers to head of list and the first element in list */
struct pidlist *pidlist_head;
struct pidlist *pidlist_first;

pthread_mutex_t *pid_lock;

void child_signal(int arg) {
    child_events++;
    signal (SIGCHLD, child_signal);
}

void * makechildren(void * ptr) {

    while (1) {
        /* Fork a child process */
        pid_t p = fork();
        if ( p == -1 ) {
            /* parent process */
            perror("fork()");
        }
        else if ( p == 0 ) {
            /* Child process */
            int arg = random() % 7; /* A random number in range 0..6 */
            char *argstr = (char *)malloc(2);
            sprintf(argstr, "%d", arg);
            execl("/bin/sleep", "sleep", argstr, NULL);
        }
         /* Only in parent process */

        struct pidlist *next = (struct pidlist*)malloc(sizeof(struct pidlist));

        next->p = -1;
        next->next = NULL;

        /* Guard by lock */
        if (pthread_mutex_lock(pid_lock) != 0)
            perror("pthread_mutex_lock()");
        pidlist_head->p = p;
        pidlist_head->next = next;
        if (pthread_mutex_unlock(pid_lock) != 0)
            perror("pthread_mutex_unlock()");
        /* End guard by lock */

        sleep(3);
    }

    return 0;
}

void waitpids() {
    struct pidlist *pl = pidlist_first;
    /* guard by lock */
    if (pthread_mutex_lock(pid_lock) != 0)
        perror("pthread_mutex_lock()");
    for (;pl->p > 0; pl = pl->next) {
        int retval = waitpid(pl->p, NULL, WNOHANG);
        if (retval > 0)
            printf("Pid %d cleaned\n", pl->p);
        else if (retval == -1)
            perror("waitpid()");
    }
    if (pthread_mutex_unlock(pid_lock) != 0)
        perror("pthread_mutex_unlock()");
    /* end guard by lock */
}

int main(int argc, char **argv) {
    sigset_t sigmask, orig_sigmask;
    fd_set rfds;
    int retval;
    void *buf = NULL;

    pidlist_first = pidlist_head =
        (struct pidlist*) malloc(sizeof(struct pidlist));

    sigemptyset(&sigmask);
    sigaddset(&sigmask, SIGCHLD);
    sigprocmask(SIG_BLOCK, &sigmask, &orig_sigmask);

    signal(SIGCHLD, child_signal);

    pid_lock = (pthread_mutex_t*) malloc(sizeof(pthread_mutex_t));
    pthread_mutex_init(pid_lock, 0);

    pthread_t forker_thread;
    retval = pthread_create(&forker_thread, 0, makechildren, 0);

    /* Main loop: Start listening to events. */
    int ok = 1;
    while (ok) {
        /* Watch stdin (fd 0). The values have to be reset after a
         * (possible) signal */
        FD_ZERO(&rfds);
        FD_SET(0, &rfds);
        retval = pselect(1, &rfds, NULL, NULL, NULL, &orig_sigmask);

        /* Got a signal, or error in select */
        if (retval == -1) {
            if (errno == EINTR) {
                /* A signal got received */
                waitpids();
            }
            else
                perror("select()");
        }

        /* Got data from input */
        else if (retval) {
            int bufsize = BUFSIZE;
            int curr = 0;
            int count = 0;

            buf = (void *) malloc(bufsize);

            printf("Data available from stdin.\n");
            int read_still = 1;
            while (read_still) {
                while (READSIZE + curr > bufsize) {
                    buf = (void *) realloc(buf, bufsize * 2);
                    bufsize = 2*bufsize;
                }
                count = read(0, buf+curr, READSIZE);
                if (count < READSIZE)
                    read_still = 0;
                curr += count;
            }

            if (count < 0)
                perror("read()");

            if (count == 0)
                ok = 0;

            else
                free(buf);

        }
    }

    return 0;
}
